/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mssql.client.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.runtime.DataSourceSupport;
import io.quarkus.reactive.datasource.runtime.ReactiveDataSourceUtil;
import io.quarkus.reactive.datasource.runtime.ReactiveDatasourceHealthCheck;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.sqlclient.Pool;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
class ReactiveMSSQLDataSourcesHealthCheck
extends ReactiveDatasourceHealthCheck {
    public ReactiveMSSQLDataSourcesHealthCheck() {
        super("Reactive MS SQL connections health check", "SELECT 1");
    }

    @PostConstruct
    protected void init() {
        ArcContainer container = Arc.container();
        DataSourceSupport support = (DataSourceSupport)container.instance(DataSourceSupport.class, new Annotation[0]).get();
        Set excludedNames = support.getHealthCheckExcludedNames();
        for (InstanceHandle handle : container.select(MSSQLPool.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            String poolName;
            if (!handle.getBean().isActive() || excludedNames.contains(poolName = ReactiveDataSourceUtil.dataSourceName((Bean)handle.getBean()))) continue;
            this.addPool(poolName, (Pool)handle.get());
        }
    }
}

