/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.mssql.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.runtime.ConnectOptionsSupplier;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.mssql.client.MSSQLPoolCreator;
import io.quarkus.reactive.mssql.client.runtime.DataSourceReactiveMSSQLConfig;
import io.quarkus.reactive.mssql.client.runtime.DataSourcesReactiveMSSQLConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mutiny.mssqlclient.MSSQLPool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.impl.Utils;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class MSSQLPoolRecorder {
    private static final Logger log = Logger.getLogger(MSSQLPoolRecorder.class);

    public RuntimeValue<io.vertx.mssqlclient.MSSQLPool> configureMSSQLPool(RuntimeValue<Vertx> vertx, Supplier<Integer> eventLoopCount, String dataSourceName, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, DataSourcesReactiveMSSQLConfig dataSourcesReactiveMSSQLConfig, ShutdownContext shutdown) {
        io.vertx.mssqlclient.MSSQLPool mssqlPool = this.initialize((VertxInternal)vertx.getValue(), eventLoopCount.get(), dataSourceName, dataSourcesRuntimeConfig.getDataSourceRuntimeConfig(dataSourceName), dataSourcesReactiveRuntimeConfig.getDataSourceReactiveRuntimeConfig(dataSourceName), dataSourcesReactiveMSSQLConfig.getDataSourceReactiveRuntimeConfig(dataSourceName));
        shutdown.addShutdownTask(() -> ((io.vertx.mssqlclient.MSSQLPool)mssqlPool).close());
        return new RuntimeValue((Object)mssqlPool);
    }

    public RuntimeValue<MSSQLPool> mutinyMSSQLPool(RuntimeValue<io.vertx.mssqlclient.MSSQLPool> mssqlPool) {
        return new RuntimeValue((Object)MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)((io.vertx.mssqlclient.MSSQLPool)mssqlPool.getValue())));
    }

    private io.vertx.mssqlclient.MSSQLPool initialize(VertxInternal vertx, Integer eventLoopCount, String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMSSQLConfig dataSourceReactiveMSSQLConfig) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMSSQLConfig);
        MSSQLConnectOptions mssqlConnectOptions = this.toMSSQLConnectOptions(dataSourceName, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveMSSQLConfig);
        Supplier<Future<MSSQLConnectOptions>> databasesSupplier = this.toDatabasesSupplier((Vertx)vertx, List.of(mssqlConnectOptions), dataSourceRuntimeConfig);
        return this.createPool((Vertx)vertx, poolOptions, mssqlConnectOptions, dataSourceName, databasesSupplier);
    }

    private Supplier<Future<MSSQLConnectOptions>> toDatabasesSupplier(Vertx vertx, List<MSSQLConnectOptions> mssqlConnectOptionsList, DataSourceRuntimeConfig dataSourceRuntimeConfig) {
        Supplier supplier;
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            supplier = new ConnectOptionsSupplier(vertx, credentialsProvider, name, mssqlConnectOptionsList, MSSQLConnectOptions::new);
        } else {
            supplier = Utils.roundRobinSupplier(mssqlConnectOptionsList);
        }
        return supplier;
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMSSQLConfig dataSourceReactiveMSSQLConfig) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize);
        if (dataSourceReactiveRuntimeConfig.idleTimeout.isPresent()) {
            int idleTimeout = Math.toIntExact(((Duration)dataSourceReactiveRuntimeConfig.idleTimeout.get()).toMillis());
            poolOptions.setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        }
        if (dataSourceReactiveRuntimeConfig.shared) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name.isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name.get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize.isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize.getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private MSSQLConnectOptions toMSSQLConnectOptions(String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveMSSQLConfig dataSourceReactiveMSSQLConfig) {
        MSSQLConnectOptions mssqlConnectOptions;
        if (dataSourceReactiveRuntimeConfig.url.isPresent()) {
            String url;
            List urls = (List)dataSourceReactiveRuntimeConfig.url.get();
            if (urls.size() > 1) {
                log.warn((Object)"The Reactive MSSQL client does not support multiple URLs. The first one will be used, and others will be ignored.");
            }
            if ((url = (String)urls.get(0)).startsWith("vertx-reactive:sqlserver://")) {
                url = url.substring("vertx-reactive:".length());
            }
            mssqlConnectOptions = MSSQLConnectOptions.fromUri((String)url);
        } else {
            mssqlConnectOptions = new MSSQLConnectOptions();
        }
        if (dataSourceReactiveMSSQLConfig.packetSize.isPresent()) {
            mssqlConnectOptions.setPacketSize(dataSourceReactiveMSSQLConfig.packetSize.getAsInt());
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            mssqlConnectOptions.setUser((String)dataSourceRuntimeConfig.username.get());
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            mssqlConnectOptions.setPassword((String)dataSourceRuntimeConfig.password.get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                mssqlConnectOptions.setUser(user);
            }
            if (password != null) {
                mssqlConnectOptions.setPassword(password);
            }
        }
        mssqlConnectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts);
        mssqlConnectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval.toMillis());
        mssqlConnectOptions.setSsl(dataSourceReactiveMSSQLConfig.ssl);
        mssqlConnectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll);
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)mssqlConnectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem);
        SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)mssqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks);
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)mssqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx);
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)mssqlConnectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)mssqlConnectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks);
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)mssqlConnectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx);
        if (dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.isPresent()) {
            mssqlConnectOptions.setHostnameVerificationAlgorithm((String)dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm.get());
        }
        dataSourceReactiveRuntimeConfig.additionalProperties.forEach((arg_0, arg_1) -> ((MSSQLConnectOptions)mssqlConnectOptions).addProperty(arg_0, arg_1));
        mssqlConnectOptions.setMetricsName("mssql|" + dataSourceName);
        return mssqlConnectOptions;
    }

    private io.vertx.mssqlclient.MSSQLPool createPool(Vertx vertx, PoolOptions poolOptions, MSSQLConnectOptions mSSQLConnectOptions, String dataSourceName, Supplier<Future<MSSQLConnectOptions>> databases) {
        InjectableInstance instance = DataSourceUtil.isDefault((String)dataSourceName) ? Arc.container().select(MSSQLPoolCreator.class, new Annotation[0]) : Arc.container().select(MSSQLPoolCreator.class, new Annotation[]{new ReactiveDataSource.ReactiveDataSourceLiteral(dataSourceName)});
        if (instance.isResolvable()) {
            DefaultInput input = new DefaultInput(vertx, poolOptions, mSSQLConnectOptions);
            return ((MSSQLPoolCreator)instance.get()).create(input);
        }
        return io.vertx.mssqlclient.MSSQLPool.pool((Vertx)vertx, databases, (PoolOptions)poolOptions);
    }

    private static class DefaultInput
    implements MSSQLPoolCreator.Input {
        private final Vertx vertx;
        private final PoolOptions poolOptions;
        private final MSSQLConnectOptions mSSQLConnectOptions;

        public DefaultInput(Vertx vertx, PoolOptions poolOptions, MSSQLConnectOptions mSSQLConnectOptions) {
            this.vertx = vertx;
            this.poolOptions = poolOptions;
            this.mSSQLConnectOptions = mSSQLConnectOptions;
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }

        @Override
        public PoolOptions poolOptions() {
            return this.poolOptions;
        }

        @Override
        public MSSQLConnectOptions msSQLConnectOptions() {
            return this.mSSQLConnectOptions;
        }
    }
}

