/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.redis.client.RedisClient;
import io.quarkus.redis.client.RedisClientName;
import io.quarkus.redis.client.RedisHostsProvider;
import io.quarkus.redis.client.RedisOptionsCustomizer;
import io.quarkus.redis.client.deployment.RedisBuildTimeConfig;
import io.quarkus.redis.client.reactive.ReactiveRedisClient;
import io.quarkus.redis.runtime.client.RedisClientRecorder;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.redis.client.RedisAPI;
import io.vertx.redis.client.impl.types.BulkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class RedisClientProcessor {
    static final DotName REDIS_CLIENT_ANNOTATION = DotName.createSimple((String)RedisClientName.class.getName());
    private static final String FEATURE = "redis-client";
    private static final List<DotName> SUPPORTED_INJECTION_TYPE = List.of(DotName.createSimple((String)RedisClient.class.getName()), DotName.createSimple((String)ReactiveRedisClient.class.getName()), DotName.createSimple((String)Redis.class.getName()), DotName.createSimple((String)RedisAPI.class.getName()), DotName.createSimple((String)io.vertx.redis.client.Redis.class.getName()), DotName.createSimple((String)io.vertx.redis.client.RedisAPI.class.getName()));

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void registerRuntimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem(BulkType.class.getName()));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisSentinelClient"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisReplicationClient"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.Slots"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisClusterConnection"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisReplicationConnection"));
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.vertx.redis.client.impl.RedisClusterClient"));
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    List<AdditionalBeanBuildItem> registerRedisClientName() {
        ArrayList<AdditionalBeanBuildItem> list = new ArrayList<AdditionalBeanBuildItem>();
        list.add(AdditionalBeanBuildItem.builder().addBeanClass(RedisClientName.class).build());
        return list;
    }

    @BuildStep
    UnremovableBeanBuildItem makeHostsProviderAndOptionsCustomizerUnremovable() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{RedisHostsProvider.class, RedisOptionsCustomizer.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void init(RedisClientRecorder recorder, BeanArchiveIndexBuildItem indexBuildItem, BeanDiscoveryFinishedBuildItem beans, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, VertxBuildItem vertxBuildItem) {
        HashSet<String> names = new HashSet<String>();
        IndexView indexView = indexBuildItem.getIndex();
        Collection clientAnnotations = indexView.getAnnotations(REDIS_CLIENT_ANNOTATION);
        for (AnnotationInstance annotation : clientAnnotations) {
            names.add(annotation.value().asString());
        }
        beans.getInjectionPoints().stream().filter(InjectionPointInfo::hasDefaultedQualifier).filter(i -> SUPPORTED_INJECTION_TYPE.contains(i.getRequiredType().name())).findAny().ifPresent(x -> names.add("<default>"));
        recorder.initialize(vertxBuildItem.getVertx(), names);
        for (String name : names) {
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, Redis.class, recorder.getRedisClient(name)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, io.vertx.redis.client.Redis.class, recorder.getBareRedisClient(name)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, RedisAPI.class, recorder.getRedisAPI(name)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, io.vertx.redis.client.RedisAPI.class, recorder.getBareRedisAPI(name)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, RedisClient.class, recorder.getLegacyRedisClient(name)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, ReactiveRedisClient.class, recorder.getLegacyReactiveRedisClient(name)));
        }
        recorder.cleanup((ShutdownContext)shutdown);
    }

    static <T> SyntheticBeanBuildItem configureAndCreateSyntheticBean(String name, Class<T> type, Supplier<T> supplier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(type).supplier(supplier).scope(ApplicationScoped.class)).unremovable()).setRuntimeInit();
        if ("<default>".equalsIgnoreCase(name)) {
            configurator.addQualifier(Default.class);
        } else {
            configurator.addQualifier().annotation(REDIS_CLIENT_ANNOTATION).addValue("value", (Object)name).done();
        }
        return configurator.done();
    }

    @BuildStep
    HealthBuildItem addHealthCheck(RedisBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.redis.runtime.client.health.RedisHealthCheck", buildTimeConfig.healthEnabled);
    }
}

