/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.client.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.redis.client.deployment.RedisClientProcessor;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.runtime.client.RedisClientRecorder;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.deployment.VertxBuildItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class RedisDatasourceProcessor {
    private static final List<DotName> SUPPORTED_INJECTION_TYPE = List.of(DotName.createSimple((String)RedisDataSource.class.getName()), DotName.createSimple((String)ReactiveRedisDataSource.class.getName()));

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void init(RedisClientRecorder recorder, BeanArchiveIndexBuildItem indexBuildItem, BeanDiscoveryFinishedBuildItem beans, ShutdownContextBuildItem shutdown, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, VertxBuildItem vertxBuildItem) {
        HashSet<String> names = new HashSet<String>();
        IndexView indexView = indexBuildItem.getIndex();
        Collection clientAnnotations = indexView.getAnnotations(RedisClientProcessor.REDIS_CLIENT_ANNOTATION);
        for (AnnotationInstance annotation : clientAnnotations) {
            names.add(annotation.value().asString());
        }
        beans.getInjectionPoints().stream().filter(InjectionPointInfo::hasDefaultedQualifier).filter(i -> SUPPORTED_INJECTION_TYPE.contains(i.getRequiredType().name())).findAny().ifPresent(x -> names.add("<default>"));
        recorder.initialize(vertxBuildItem.getVertx(), names);
        for (String name : names) {
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, RedisDataSource.class, recorder.getBlockingDataSource(name)));
            syntheticBeans.produce((BuildItem)RedisClientProcessor.configureAndCreateSyntheticBean(name, ReactiveRedisDataSource.class, recorder.getReactiveDataSource(name)));
        }
        recorder.cleanup((ShutdownContext)shutdown);
    }
}

