/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.geo;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.util.ArrayList;
import java.util.List;

public class GeoRadiusArgs
implements RedisCommandExtraArguments {
    private boolean withDistance;
    private boolean withCoordinates;
    private boolean withHash;
    private long count = -1L;
    private boolean any;
    private String direction;

    public GeoRadiusArgs ascending() {
        this.direction = "ASC";
        return this;
    }

    public GeoRadiusArgs descending() {
        this.direction = "DESC";
        return this;
    }

    public GeoRadiusArgs withDistance() {
        this.withDistance = true;
        return this;
    }

    public GeoRadiusArgs withCoordinates() {
        this.withCoordinates = true;
        return this;
    }

    public GeoRadiusArgs withHash() {
        this.withHash = true;
        return this;
    }

    public GeoRadiusArgs count(long count) {
        this.count = count;
        return this;
    }

    public GeoRadiusArgs any() {
        this.any = true;
        return this;
    }

    @Override
    public List<String> toArgs() {
        if (this.any && this.count == -1L) {
            throw new IllegalArgumentException("ANY can only be used if COUNT is also set");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.withDistance) {
            list.add("WITHDIST");
        }
        if (this.withCoordinates) {
            list.add("WITHCOORD");
        }
        if (this.withHash) {
            list.add("WITHHASH");
        }
        if (this.count > 0L) {
            list.add("COUNT");
            list.add(Long.toString(this.count));
        }
        if (this.any) {
            list.add("ANY");
        }
        list.add(this.direction);
        return list;
    }

    public boolean hasDistance() {
        return this.withDistance;
    }

    public boolean hasHash() {
        return this.withHash;
    }

    public boolean hasCoordinates() {
        return this.withCoordinates;
    }
}

