/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.datasource.search.FieldOptions;
import io.quarkus.redis.datasource.search.FieldType;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.ArrayList;
import java.util.List;

public class IndexedField
implements RedisCommandExtraArguments {
    private final String field;
    private final String alias;
    private final FieldType type;
    private final FieldOptions options;

    public static IndexedField from(String field, String alias, FieldType type, FieldOptions options) {
        return new IndexedField(field, alias, type, options);
    }

    public static IndexedField from(String field, FieldType type, FieldOptions options) {
        return new IndexedField(field, null, type, options);
    }

    public static IndexedField from(String field, FieldType type) {
        return new IndexedField(field, null, type, null);
    }

    public static IndexedField from(String field, String alias, FieldType type) {
        return new IndexedField(field, alias, type, null);
    }

    IndexedField(String field, String alias, FieldType type, FieldOptions options) {
        this.field = Validation.notNullOrBlank(field, "field");
        this.alias = alias;
        this.type = (FieldType)((Object)ParameterValidation.nonNull((Object)((Object)type), (String)"type"));
        this.options = options;
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.field);
        if (this.alias != null) {
            list.add("AS");
            list.add(this.alias);
        }
        list.add(this.type.toString());
        if (this.options != null) {
            list.addAll(this.options.toArgs());
        }
        return list;
    }
}

