/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.stream;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class XAddArgs
implements RedisCommandExtraArguments {
    private String id;
    private long maxlen = -1L;
    private boolean approximateTrimming;
    private boolean nomkstream;
    private String minid;
    private long limit = -1L;

    public XAddArgs id(String id) {
        this.id = id;
        return this;
    }

    public XAddArgs maxlen(Long maxlen) {
        this.maxlen = maxlen;
        return this;
    }

    public XAddArgs nearlyExactTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XAddArgs nomkstream() {
        this.nomkstream = true;
        return this;
    }

    public XAddArgs minid(String minid) {
        this.minid = minid;
        return this;
    }

    public XAddArgs limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public List<String> toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.nomkstream) {
            args.add("NOMKSTREAM");
        }
        if (this.maxlen > 0L) {
            if (this.minid != null) {
                throw new IllegalArgumentException("Cannot use `MAXLEN` and `MINID` together");
            }
            args.add("MAXLEN");
            if (this.approximateTrimming) {
                args.add("~");
            } else {
                args.add("=");
            }
            args.add(Long.toString(this.maxlen));
        }
        if (this.minid != null) {
            args.add("MINID");
            if (this.approximateTrimming) {
                args.add("~");
            } else {
                args.add("=");
            }
            args.add(this.minid);
        }
        if (this.limit > 0L) {
            if (!this.approximateTrimming) {
                throw new IllegalArgumentException("Cannot set the eviction limit when using exact trimming");
            }
            args.add("LIMIT");
            args.add(Long.toString(this.limit));
        }
        args.add(Objects.requireNonNullElse(this.id, "*"));
        return args;
    }
}

