/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.timeseries;

import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.List;

public class TimeSeriesRange {
    private final long start;
    private final long end;

    private TimeSeriesRange(long s, long e) {
        this.start = ParameterValidation.positiveOrZero((long)s, (String)"start");
        this.end = ParameterValidation.positiveOrZero((long)e, (String)"end");
    }

    public static TimeSeriesRange fromTimestamps(long begin, long end) {
        return new TimeSeriesRange(begin, end);
    }

    public static TimeSeriesRange fromTimeSeries() {
        return new TimeSeriesRange(Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public static TimeSeriesRange fromEarliestToTimestamp(long end) {
        return new TimeSeriesRange(Long.MAX_VALUE, end);
    }

    public static TimeSeriesRange fromTimestampToLatest(long begin) {
        return new TimeSeriesRange(begin, Long.MAX_VALUE);
    }

    public List<String> toArgs() {
        return List.of(this.start == Long.MAX_VALUE ? "-" : Long.toString(this.start), this.end == Long.MAX_VALUE ? "+" : Long.toString(this.end));
    }
}

