/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.bitmap.BitFieldArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.util.List;

class AbstractBitMapCommands<K>
extends AbstractRedisCommands {
    AbstractBitMapCommands(RedisCommandExecutor redis, Class<K> k) {
        super(redis, new Marshaller(k));
    }

    Uni<Response> _bitcount(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.BITCOUNT).put(this.marshaller.encode(key)));
    }

    Uni<Response> _bitcount(K key, long start, long end) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.BITCOUNT).put(this.marshaller.encode(key)).put(start).put(end));
    }

    Uni<Response> _bitfield(K key, BitFieldArgs bitFieldArgs) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)bitFieldArgs, (String)"bitFieldArgs");
        return this.execute(RedisCommand.of(Command.BITFIELD).put(this.marshaller.encode(key)).putArgs(bitFieldArgs));
    }

    Uni<Response> _bitpos(K key, int bit) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.isBit(bit, "bit");
        return this.execute(RedisCommand.of(Command.BITPOS).put(this.marshaller.encode(key)).put(bit));
    }

    Uni<Response> _bitpos(K key, int bit, long start) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.isBit(bit, "bit");
        return this.execute(RedisCommand.of(Command.BITPOS).put(this.marshaller.encode(key)).put(bit).put(start));
    }

    Uni<Response> _bitpos(K key, int bit, long start, long end) {
        ParameterValidation.nonNull(key, (String)"key");
        return this.execute(RedisCommand.of(Command.BITPOS).put(this.marshaller.encode(key)).put(bit).put(start).put(end));
    }

    Uni<Response> _bitopAnd(K destination, K ... keys) {
        ParameterValidation.nonNull(destination, (String)"destination");
        Validation.notNullOrEmpty(keys, "keys");
        return this.execute(RedisCommand.of(Command.BITOP).put("AND").put(this.marshaller.encode(destination)).put(this.marshaller.encode(keys)));
    }

    Uni<Response> _bitopNot(K destination, K source) {
        ParameterValidation.nonNull(destination, (String)"destination");
        ParameterValidation.nonNull(source, (String)"source");
        return this.execute(RedisCommand.of(Command.BITOP).put("NOT").put(this.marshaller.encode(destination)).put(this.marshaller.encode(source)));
    }

    final Uni<Response> _bitopOr(K destination, K ... keys) {
        ParameterValidation.nonNull(destination, (String)"destination");
        Validation.notNullOrEmpty(keys, "keys");
        return this.execute(RedisCommand.of(Command.BITOP).put("OR").put(this.marshaller.encode(destination)).put(this.marshaller.encode(keys)));
    }

    @SafeVarargs
    final Uni<Response> _bitopXor(K destination, K ... keys) {
        ParameterValidation.nonNull(destination, (String)"destination");
        Validation.notNullOrEmpty(keys, "keys");
        return this.execute(RedisCommand.of(Command.BITOP).put("XOR").put(this.marshaller.encode(destination)).put(this.marshaller.encode(keys)));
    }

    List<Long> decodeListOfLongs(Response r) {
        return this.marshaller.decodeAsList(r, Response::toLong);
    }

    Uni<Response> _setbit(K key, long offset, int value) {
        ParameterValidation.nonNull(key, (String)"key");
        Validation.isBit(value, "value");
        return this.execute(RedisCommand.of(Command.SETBIT).put(this.marshaller.encode(key)).put(offset).put(value));
    }

    Uni<Response> _getbit(K key, long offset) {
        return this.execute(RedisCommand.of(Command.GETBIT).put(this.marshaller.encode(key)).put(offset));
    }
}

