/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.sortedset.ReactiveZScanCursor;
import io.quarkus.redis.datasource.sortedset.ScoredValue;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.util.ArrayList;
import java.util.List;

public class ZScanReactiveCursorImpl<V>
extends AbstractRedisCommands
implements ReactiveZScanCursor<V> {
    private final byte[] key;
    private final Class<V> typeOfValue;
    private long cursor;
    private final List<String> extra = new ArrayList<String>();

    public <K> ZScanReactiveCursorImpl(RedisCommandExecutor redis, K key, Marshaller marshaller, Class<V> typeOfValue, List<String> extra) {
        super(redis, marshaller);
        this.key = marshaller.encode(key);
        this.cursor = -1L;
        this.typeOfValue = typeOfValue;
        this.extra.addAll(extra);
    }

    @Override
    public boolean hasNext() {
        return this.cursor != 0L;
    }

    @Override
    public Uni<List<ScoredValue<V>>> next() {
        RedisCommand cmd = RedisCommand.of(Command.ZSCAN);
        long pos = this.cursor == -1L ? 0L : this.cursor;
        cmd.put(this.key);
        cmd.put(Long.toString(pos));
        cmd.putAll(this.extra);
        return this.execute(cmd).invoke(response -> {
            this.cursor = response.get(0).toLong();
        }).map(response -> {
            Response array = response.get(1);
            Object value = null;
            ArrayList<ScoredValue<Object>> list = new ArrayList<ScoredValue<Object>>();
            for (Response nested : array) {
                if (value == null) {
                    value = this.marshaller.decode(this.typeOfValue, nested.toBytes());
                    continue;
                }
                list.add(new ScoredValue<Object>(value, nested.toDouble()));
                value = null;
            }
            return list;
        });
    }

    @Override
    public long cursorId() {
        return this.cursor;
    }

    @Override
    public Multi<ScoredValue<V>> toMulti() {
        return Multi.createBy().repeating().uni(this::next).whilst(m -> !m.isEmpty() && this.hasNext()).onItem().transformToMultiAndConcatenate(list -> Multi.createFrom().items(list.stream()));
    }
}

