/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.stream.ClaimedMessages;
import io.quarkus.redis.datasource.stream.PendingMessage;
import io.quarkus.redis.datasource.stream.ReactiveStreamCommands;
import io.quarkus.redis.datasource.stream.StreamCommands;
import io.quarkus.redis.datasource.stream.StreamMessage;
import io.quarkus.redis.datasource.stream.StreamRange;
import io.quarkus.redis.datasource.stream.XAddArgs;
import io.quarkus.redis.datasource.stream.XClaimArgs;
import io.quarkus.redis.datasource.stream.XGroupCreateArgs;
import io.quarkus.redis.datasource.stream.XGroupSetIdArgs;
import io.quarkus.redis.datasource.stream.XPendingArgs;
import io.quarkus.redis.datasource.stream.XPendingSummary;
import io.quarkus.redis.datasource.stream.XReadArgs;
import io.quarkus.redis.datasource.stream.XReadGroupArgs;
import io.quarkus.redis.datasource.stream.XTrimArgs;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class BlockingStreamCommandsImpl<K, F, V>
extends AbstractRedisCommandGroup
implements StreamCommands<K, F, V> {
    private final ReactiveStreamCommands<K, F, V> reactive;

    public BlockingStreamCommandsImpl(RedisDataSource ds, ReactiveStreamCommands<K, F, V> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public int xack(K key, String group, String ... ids) {
        return (Integer)this.reactive.xack(key, group, ids).await().atMost(this.timeout);
    }

    @Override
    public String xadd(K key, Map<F, V> payload) {
        return (String)this.reactive.xadd(key, payload).await().atMost(this.timeout);
    }

    @Override
    public String xadd(K key, XAddArgs args, Map<F, V> payload) {
        return (String)this.reactive.xadd(key, args, payload).await().atMost(this.timeout);
    }

    @Override
    public ClaimedMessages<K, F, V> xautoclaim(K key, String group, String consumer, Duration minIdleTime, String start, int count) {
        return (ClaimedMessages)this.reactive.xautoclaim(key, group, consumer, minIdleTime, start, count).await().atMost(this.timeout);
    }

    @Override
    public ClaimedMessages<K, F, V> xautoclaim(K key, String group, String consumer, Duration minIdleTime, String start) {
        return (ClaimedMessages)this.reactive.xautoclaim(key, group, consumer, minIdleTime, start).await().atMost(this.timeout);
    }

    @Override
    public ClaimedMessages<K, F, V> xautoclaim(K key, String group, String consumer, Duration minIdleTime, String start, int count, boolean justId) {
        return (ClaimedMessages)this.reactive.xautoclaim(key, group, consumer, minIdleTime, start, count, justId).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xclaim(K key, String group, String consumer, Duration minIdleTime, String ... id) {
        return (List)this.reactive.xclaim(key, group, consumer, minIdleTime, id).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xclaim(K key, String group, String consumer, Duration minIdleTime, XClaimArgs args, String ... id) {
        return (List)this.reactive.xclaim(key, group, consumer, minIdleTime, args, id).await().atMost(this.timeout);
    }

    @Override
    public int xdel(K key, String ... id) {
        return (Integer)this.reactive.xdel(key, id).await().atMost(this.timeout);
    }

    @Override
    public void xgroupCreate(K key, String groupname, String from) {
        this.reactive.xgroupCreate(key, groupname, from).await().atMost(this.timeout);
    }

    @Override
    public void xgroupCreate(K key, String groupname, String from, XGroupCreateArgs args) {
        this.reactive.xgroupCreate(key, groupname, from, args).await().atMost(this.timeout);
    }

    @Override
    public boolean xgroupCreateConsumer(K key, String groupname, String consumername) {
        return (Boolean)this.reactive.xgroupCreateConsumer(key, groupname, consumername).await().atMost(this.timeout);
    }

    @Override
    public long xgroupDelConsumer(K key, String groupname, String consumername) {
        return (Long)this.reactive.xgroupDelConsumer(key, groupname, consumername).await().atMost(this.timeout);
    }

    @Override
    public boolean xgroupDestroy(K key, String groupname) {
        return (Boolean)this.reactive.xgroupDestroy(key, groupname).await().atMost(this.timeout);
    }

    @Override
    public void xgroupSetId(K key, String groupname, String from) {
        this.reactive.xgroupSetId(key, groupname, from).await().atMost(this.timeout);
    }

    @Override
    public void xgroupSetId(K key, String groupname, String from, XGroupSetIdArgs args) {
        this.reactive.xgroupSetId(key, groupname, from, args).await().atMost(this.timeout);
    }

    @Override
    public long xlen(K key) {
        return (Long)this.reactive.xlen(key).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xrange(K key, StreamRange range, int count) {
        return (List)this.reactive.xrange(key, range, count).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xrange(K key, StreamRange range) {
        return (List)this.reactive.xrange(key, range).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xread(K key, String id) {
        return (List)this.reactive.xread(key, id).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xread(Map<K, String> lastIdsPerStream) {
        return (List)this.reactive.xread(lastIdsPerStream).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xread(K key, String id, XReadArgs args) {
        return (List)this.reactive.xread(key, id, args).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xread(Map<K, String> lastIdsPerStream, XReadArgs args) {
        return (List)this.reactive.xread(lastIdsPerStream, args).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xreadgroup(String group, String consumer, K key, String id) {
        return (List)this.reactive.xreadgroup(group, consumer, key, id).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xreadgroup(String group, String consumer, Map<K, String> lastIdsPerStream) {
        return (List)this.reactive.xreadgroup(group, consumer, lastIdsPerStream).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xreadgroup(String group, String consumer, K key, String id, XReadGroupArgs args) {
        return (List)this.reactive.xreadgroup(group, consumer, key, id, args).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xreadgroup(String group, String consumer, Map<K, String> lastIdsPerStream, XReadGroupArgs args) {
        return (List)this.reactive.xreadgroup(group, consumer, lastIdsPerStream, args).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xrevrange(K key, StreamRange range, int count) {
        return (List)this.reactive.xrevrange(key, range, count).await().atMost(this.timeout);
    }

    @Override
    public List<StreamMessage<K, F, V>> xrevrange(K key, StreamRange range) {
        return (List)this.reactive.xrevrange(key, range).await().atMost(this.timeout);
    }

    @Override
    public long xtrim(K key, String threshold) {
        return (Long)this.reactive.xtrim(key, threshold).await().atMost(this.timeout);
    }

    @Override
    public long xtrim(K key, XTrimArgs args) {
        return (Long)this.reactive.xtrim(key, args).await().atMost(this.timeout);
    }

    @Override
    public XPendingSummary xpending(K key, String group) {
        return (XPendingSummary)this.reactive.xpending(key, group).await().atMost(this.timeout);
    }

    @Override
    public List<PendingMessage> xpending(K key, String group, StreamRange range, int count) {
        return (List)this.reactive.xpending(key, group, range, count).await().atMost(this.timeout);
    }

    @Override
    public List<PendingMessage> xpending(K key, String group, StreamRange range, int count, XPendingArgs args) {
        return (List)this.reactive.xpending(key, group, range, count, args).await().atMost(this.timeout);
    }
}

