/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.timeseries;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.datasource.timeseries.DuplicatePolicy;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlterArgs
implements RedisCommandExtraArguments {
    private Duration retention;
    private String enc;
    private int chunkSize;
    private DuplicatePolicy policy;
    private final Map<String, Object> labels = new HashMap<String, Object>();

    public AlterArgs setRetention(Duration retention) {
        this.retention = (Duration)ParameterValidation.nonNull((Object)retention, (String)"retention");
        return this;
    }

    public AlterArgs forever() {
        this.retention = Duration.ZERO;
        return this;
    }

    public AlterArgs chunkSize(int size) {
        this.chunkSize = size;
        return this;
    }

    public AlterArgs duplicatePolicy(DuplicatePolicy policy) {
        this.policy = policy;
        return this;
    }

    public AlterArgs label(String label, Object value) {
        this.labels.put(label, value);
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.retention != null) {
            list.add("RETENTION");
            if (this.retention == Duration.ZERO) {
                list.add("0");
            } else {
                list.add(Long.toString(this.retention.toMillis()));
            }
        }
        if (this.enc != null) {
            list.add("ENCODING");
            list.add(this.enc);
        }
        if (this.chunkSize > 0) {
            list.add("CHUNK_SIZE");
            list.add(Integer.toString(this.chunkSize));
        }
        if (this.policy != null) {
            list.add("DUPLICATE_POLICY");
            list.add(this.policy.name().toUpperCase());
        }
        if (!this.labels.isEmpty()) {
            list.add("LABELS");
            for (Map.Entry<String, Object> entry : this.labels.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue().toString());
            }
        }
        return list;
    }
}

