/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.graph.GraphCommands;
import io.quarkus.redis.datasource.graph.GraphQueryResponseItem;
import io.quarkus.redis.datasource.graph.ReactiveGraphCommands;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommandGroup;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class BlockingGraphCommandsImpl<K>
extends AbstractRedisCommandGroup
implements GraphCommands<K> {
    private final ReactiveGraphCommands<K> reactive;

    public BlockingGraphCommandsImpl(RedisDataSource ds, ReactiveGraphCommands<K> reactive, Duration timeout) {
        super(ds, timeout);
        this.reactive = reactive;
    }

    @Override
    public void graphDelete(K key) {
        this.reactive.graphDelete(key).await().atMost(this.timeout);
    }

    @Override
    public String graphExplain(K key, String query) {
        return (String)this.reactive.graphExplain(key, query).await().atMost(this.timeout);
    }

    @Override
    public List<K> graphList() {
        return (List)this.reactive.graphList().await().atMost(this.timeout);
    }

    @Override
    public List<Map<String, GraphQueryResponseItem>> graphQuery(K key, String query) {
        return (List)this.reactive.graphQuery(key, query).await().atMost(this.timeout);
    }

    @Override
    public List<Map<String, GraphQueryResponseItem>> graphQuery(K key, String query, Duration timeout) {
        return (List)this.reactive.graphQuery(key, query, timeout).await().atMost(this.timeout);
    }
}

