/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.hash.ReactiveHashScanCursor;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HScanReactiveCursorImpl<F, V>
extends AbstractRedisCommands
implements ReactiveHashScanCursor<F, V> {
    private final byte[] key;
    private final Type typeOfField;
    private final Type typeOfValue;
    private long cursor;
    private final List<String> extra = new ArrayList<String>();

    public <K> HScanReactiveCursorImpl(RedisCommandExecutor redis, K key, Marshaller marshaller, Type typeOfField, Type typeOfValue, List<String> extra) {
        super(redis, marshaller);
        this.key = marshaller.encode(key);
        this.typeOfField = typeOfField;
        this.typeOfValue = typeOfValue;
        this.cursor = -1L;
        this.extra.addAll(extra);
    }

    @Override
    public boolean hasNext() {
        return this.cursor != 0L;
    }

    @Override
    public Uni<Map<F, V>> next() {
        long pos = this.cursor == -1L ? 0L : this.cursor;
        RedisCommand cmd = RedisCommand.of(Command.HSCAN);
        cmd.put(this.key);
        cmd.put(pos);
        cmd.putAll(this.extra);
        return this.execute(cmd).invoke(response -> {
            this.cursor = response.get(0).toLong();
        }).map(response -> this.decode(response.get(1)));
    }

    @Override
    public Multi<Map.Entry<F, V>> toMulti() {
        return Multi.createBy().repeating().uni(this::next).whilst(m -> this.hasNext()).onItem().transformToMultiAndConcatenate(map -> Multi.createFrom().items(map.entrySet().stream()));
    }

    public Map<F, V> decode(Response response) {
        LinkedHashMap map = new LinkedHashMap();
        Object field = null;
        for (Response member : response) {
            if (field == null) {
                field = this.marshaller.decode(this.typeOfField, member);
                continue;
            }
            Object val = this.marshaller.decode(this.typeOfValue, member);
            map.put(field, val);
            field = null;
        }
        return map;
    }

    @Override
    public long cursorId() {
        return this.cursor;
    }
}

