/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.restclient.config.AbstractRestClientConfigBuilder;
import io.quarkus.restclient.config.RegisteredRestClient;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import jakarta.annotation.Priority;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

@Priority(value=3610)
public class RestClientNameFallbackInterceptor
extends FallbackConfigSourceInterceptor {
    public RestClientNameFallbackInterceptor(List<RegisteredRestClient> restClients, Set<String> ignoreNames) {
        super(RestClientNameFallbackInterceptor.fallback(restClients, ignoreNames));
    }

    private static Function<String, String> fallback(final List<RegisteredRestClient> restClients, final Set<String> ignoreNames) {
        return new Function<String, String>(){

            @Override
            public String apply(String name) {
                int indexOfRestClient = AbstractRestClientConfigBuilder.indexOfRestClient(name);
                if (indexOfRestClient != -1) {
                    if (ignoreNames.contains(name)) {
                        return name;
                    }
                    int endOfRestClient = indexOfRestClient + 1;
                    for (RegisteredRestClient restClient : restClients) {
                        if (name.length() <= indexOfRestClient || name.charAt(indexOfRestClient) != '\"') continue;
                        String interfaceName = restClient.getFullName();
                        if (name.regionMatches(endOfRestClient, interfaceName, 0, interfaceName.length()) && name.length() > endOfRestClient + interfaceName.length() && name.charAt(endOfRestClient + interfaceName.length()) == '\"') {
                            return "quarkus.rest-client." + restClient.getSimpleName() + name.substring(endOfRestClient + interfaceName.length() + 1);
                        }
                        String configKey = restClient.getConfigKey();
                        if (configKey == null || configKey.isEmpty() || restClient.isConfigKeySegments()) continue;
                        int endOfConfigKey = endOfRestClient + configKey.length();
                        if (!name.regionMatches(endOfRestClient, configKey, 0, configKey.length()) || name.length() <= endOfConfigKey || name.charAt(endOfConfigKey) != '\"') continue;
                        return "quarkus.rest-client." + configKey + name.substring(endOfConfigKey + 1);
                    }
                }
                return name;
            }
        };
    }
}

