/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.restclient.config.RegisteredRestClient;
import io.quarkus.restclient.config.RestClientNameFallbackInterceptor;
import io.quarkus.restclient.config.RestClientNameUnquotedFallbackInterceptor;
import io.quarkus.restclient.config.RestClientsConfig;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractRestClientConfigBuilder
implements ConfigBuilder {
    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        List<RegisteredRestClient> restClients = this.getRestClients();
        Set<String> ignoreNames = this.getIgnoreNames();
        builder.withInterceptors(new ConfigSourceInterceptor[]{new RestClientNameUnquotedFallbackInterceptor(restClients, ignoreNames)});
        builder.withInterceptors(new ConfigSourceInterceptor[]{new RestClientNameFallbackInterceptor(restClients, ignoreNames)});
        for (RegisteredRestClient restClient : restClients) {
            builder.withDefaultValue("quarkus.rest-client.\"" + restClient.getFullName() + "\".force", "true");
            builder.withDefaultValue("quarkus.rest-client." + restClient.getSimpleName() + ".force", "true");
            if (restClient.getConfigKey() == null) continue;
            builder.withDefaultValue("quarkus.rest-client.\"" + restClient.getConfigKey() + "\".force", "true");
        }
        return builder;
    }

    public abstract List<RegisteredRestClient> getRestClients();

    public Set<String> getIgnoreNames() {
        Class implementationClass = ConfigMappingLoader.getImplementationClass(RestClientsConfig.class);
        return AbstractRestClientConfigBuilder.configMappingNames(implementationClass).get(RestClientsConfig.class.getName()).get("").stream().filter(s -> s.charAt(0) != '*').map(s -> "quarkus.rest-client." + s).collect(Collectors.toSet());
    }

    @Deprecated(forRemoval=true)
    static <T> Map<String, Map<String, Set<String>>> configMappingNames(Class<T> implementationClass) {
        try {
            Method getNames = implementationClass.getDeclaredMethod("getNames", new Class[0]);
            return (Map)getNames.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
    }

    static int indexOfRestClient(String name) {
        if (name.startsWith("quarkus.rest-client.")) {
            return 20;
        }
        return -1;
    }
}

