/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocIgnore;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.MemorySize;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;

@ConfigMapping(prefix="quarkus.rest-client")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface RestClientsConfig {
    @WithParentName
    @WithDefaults
    @ConfigDocMapKey(value="client")
    public Map<String, RestClientConfig> clients();

    public Optional<String> multipartPostEncoderMode();

    public Optional<String> proxyAddress();

    public Optional<String> proxyUser();

    public Optional<String> proxyPassword();

    public Optional<String> nonProxyHosts();

    @WithDefault(value="15000")
    public Long connectTimeout();

    @WithDefault(value="30000")
    public Long readTimeout();

    @WithDefault(value="false")
    public boolean disableContextualErrorMessages();

    public Optional<String> userAgent();

    @ConfigDocMapKey(value="header-name")
    public Map<String, String> headers();

    public Optional<String> hostnameVerifier();

    public Optional<Integer> connectionTTL();

    public Optional<Integer> connectionPoolSize();

    @WithDefault(value="true")
    public Optional<Boolean> keepAliveEnabled();

    public Optional<Integer> maxRedirects();

    public Optional<Boolean> followRedirects();

    public Optional<String> providers();

    public Optional<String> scope();

    public Optional<QueryParamStyle> queryParamStyle();

    public Optional<Boolean> verifyHost();

    public Optional<String> trustStore();

    public Optional<String> trustStorePassword();

    public Optional<String> trustStoreType();

    public Optional<String> keyStore();

    public Optional<String> keyStorePassword();

    public Optional<String> keyStoreType();

    public Optional<String> tlsConfigurationName();

    @WithDefault(value="false")
    public boolean http2();

    @ConfigDocDefault(value="8k")
    public Optional<MemorySize> maxChunkSize();

    public Optional<Boolean> alpn();

    @WithDefault(value="false")
    public boolean captureStacktrace();

    public RestClientLoggingConfig logging();

    public RestClientMultipartConfig multipart();

    default public RestClientConfig getClient(Class<?> restClientInterface) {
        if (this.clients().containsKey(restClientInterface.getName())) {
            return this.clients().get(restClientInterface.getName());
        }
        return this.clients().get(restClientInterface.getSimpleName());
    }

    default public RestClientConfig getClient(String restClientConfigKey) {
        return this.clients().get(restClientConfigKey);
    }

    public static interface RestClientConfig {
        @WithDefault(value="true")
        @ConfigDocIgnore
        public boolean force();

        public RestClientMultipartConfig multipart();

        public Optional<String> url();

        @ConfigDocIgnore
        @WithName(value="url")
        public ConfigValue urlValue();

        default public Optional<String> urlReload() {
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
            return config.getOptionalValue(this.urlValue().getName(), String.class);
        }

        public Optional<String> uri();

        @ConfigDocIgnore
        @WithName(value="uri")
        public ConfigValue uriValue();

        default public Optional<String> uriReload() {
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
            return config.getOptionalValue(this.uriValue().getName(), String.class);
        }

        public Optional<String> overrideUri();

        public Optional<String> providers();

        public Optional<Long> connectTimeout();

        public Optional<Long> readTimeout();

        public Optional<Boolean> followRedirects();

        public Optional<String> multipartPostEncoderMode();

        public Optional<String> proxyAddress();

        public Optional<String> proxyUser();

        public Optional<String> proxyPassword();

        public Optional<String> nonProxyHosts();

        public Optional<QueryParamStyle> queryParamStyle();

        public Optional<Boolean> verifyHost();

        public Optional<String> trustStore();

        public Optional<String> trustStorePassword();

        public Optional<String> trustStoreType();

        public Optional<String> keyStore();

        public Optional<String> keyStorePassword();

        public Optional<String> keyStoreType();

        public Optional<String> hostnameVerifier();

        public Optional<String> tlsConfigurationName();

        public Optional<Integer> connectionTTL();

        public Optional<Integer> connectionPoolSize();

        public Optional<Boolean> keepAliveEnabled();

        public Optional<Integer> maxRedirects();

        @ConfigDocMapKey(value="header-name")
        public Map<String, String> headers();

        public Optional<Boolean> shared();

        public Optional<String> name();

        public Optional<String> userAgent();

        public Optional<Boolean> http2();

        @ConfigDocDefault(value="8K")
        public Optional<MemorySize> maxChunkSize();

        public Optional<Boolean> alpn();

        public Optional<Boolean> captureStacktrace();
    }

    public static interface RestClientMultipartConfig {
        @Deprecated
        public Optional<Integer> maxChunkSize();
    }

    public static interface RestClientLoggingConfig {
        public Optional<String> scope();

        @WithDefault(value="100")
        public Integer bodyLimit();
    }
}

