/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.deployment.GeneratedClassResult;
import io.quarkus.rest.client.reactive.runtime.ResteasyReactiveResponseRedirectHandler;
import io.quarkus.runtime.util.HashUtil;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.LinkedHashMap;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

class ClientRedirectHandler {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ResultHandle[] EMPTY_RESULT_HANDLES_ARRAY = new ResultHandle[0];
    private final ClassOutput classOutput;

    ClientRedirectHandler(ClassOutput classOutput) {
        this.classOutput = classOutput;
    }

    GeneratedClassResult generateResponseExceptionMapper(AnnotationInstance instance) {
        if (!DotNames.CLIENT_REDIRECT_HANDLER.equals((Object)instance.name())) {
            throw new IllegalArgumentException("'clientRedirectHandlerInstance' must be an instance of " + DotNames.CLIENT_REDIRECT_HANDLER);
        }
        MethodInfo targetMethod = null;
        boolean isValid = false;
        if (instance.target().kind() == AnnotationTarget.Kind.METHOD) {
            targetMethod = instance.target().asMethod();
            if (ClientRedirectHandler.ignoreAnnotation(targetMethod)) {
                return null;
            }
            if ((targetMethod.flags() & 8) != 0) {
                String returnTypeClassName = targetMethod.returnType().name().toString();
                try {
                    boolean returnsUri = URI.class.isAssignableFrom(Class.forName(returnTypeClassName, false, Thread.currentThread().getContextClassLoader()));
                    if (returnsUri) {
                        isValid = true;
                    }
                }
                catch (ClassNotFoundException returnsUri) {
                    // empty catch block
                }
            }
        }
        if (!isValid) {
            String message = DotNames.CLIENT_REDIRECT_HANDLER + " is only supported on static methods of REST Client interfaces that take 'jakarta.ws.rs.core.Response' as a single parameter and return 'java.net.URI'.";
            if (targetMethod != null) {
                message = message + " Offending instance is '" + targetMethod.declaringClass().name().toString() + "#" + targetMethod.name() + "'";
            }
            throw new IllegalStateException(message);
        }
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(targetMethod.name()).append("_").append(targetMethod.returnType().name().toString());
        for (Type i : targetMethod.parameterTypes()) {
            sigBuilder.append(i.name().toString());
        }
        int priority = 5000;
        AnnotationValue priorityAnnotationValue = instance.value("priority");
        if (priorityAnnotationValue != null) {
            priority = priorityAnnotationValue.asInt();
        }
        ClassInfo restClientInterfaceClassInfo = targetMethod.declaringClass();
        String generatedClassName = restClientInterfaceClassInfo.name().toString() + "_" + targetMethod.name() + "_ResponseRedirectHandler_" + HashUtil.sha1((String)sigBuilder.toString());
        try (ClassCreator cc = ClassCreator.builder().classOutput(this.classOutput).className(generatedClassName).interfaces(new Class[]{ResteasyReactiveResponseRedirectHandler.class}).build();){
            MethodCreator handle = cc.getMethodCreator("handle", URI.class, new Class[]{Response.class});
            LinkedHashMap<String, ResultHandle> targetMethodParams = new LinkedHashMap<String, ResultHandle>();
            for (Type paramType : targetMethod.parameterTypes()) {
                if (!paramType.name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
                    String message = DotNames.CLIENT_EXCEPTION_MAPPER + " can only take parameters of type '" + ResteasyReactiveDotNames.RESPONSE + "' or '" + DotNames.METHOD + "' Offending instance is '" + targetMethod.declaringClass().name().toString() + "#" + targetMethod.name() + "'";
                    throw new IllegalStateException(message);
                }
                ResultHandle targetMethodParamHandle = handle.getMethodParam(0);
                targetMethodParams.put(paramType.name().toString(), targetMethodParamHandle);
            }
            ResultHandle resultHandle = handle.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod((String)restClientInterfaceClassInfo.name().toString(), (String)targetMethod.name(), (String)targetMethod.returnType().name().toString(), (String[])targetMethodParams.keySet().toArray(EMPTY_STRING_ARRAY)), targetMethodParams.values().toArray(EMPTY_RESULT_HANDLES_ARRAY));
            handle.returnValue(resultHandle);
            if (priority != 5000) {
                MethodCreator getPriority = cc.getMethodCreator("getPriority", Integer.TYPE, new Class[0]);
                getPriority.returnValue(getPriority.load(priority));
            }
        }
        return new GeneratedClassResult(restClientInterfaceClassInfo.name().toString(), generatedClassName, priority);
    }

    private static boolean ignoreAnnotation(MethodInfo methodInfo) {
        return methodInfo.declaringClass().name().toString().contains("$Companion");
    }
}

