/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment.devservices;

import io.quarkus.rest.client.reactive.spi.DevServicesRestClientProxyProvider;
import io.quarkus.rest.client.reactive.spi.RestClientHttpProxyBuildItem;
import io.quarkus.runtime.ResettableSystemProperties;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.httpproxy.HttpProxy;
import io.vertx.httpproxy.ProxyContext;
import io.vertx.httpproxy.ProxyInterceptor;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

public class VertxHttpProxyDevServicesRestClientProxyProvider
implements DevServicesRestClientProxyProvider {
    public static final VertxHttpProxyDevServicesRestClientProxyProvider INSTANCE = new VertxHttpProxyDevServicesRestClientProxyProvider();
    static final String NAME = "default";
    protected static final Logger log = Logger.getLogger(VertxHttpProxyDevServicesRestClientProxyProvider.class);
    private static final AtomicReference<Vertx> vertx = new AtomicReference();

    protected VertxHttpProxyDevServicesRestClientProxyProvider() {
    }

    public String name() {
        return NAME;
    }

    public Closeable setup() {
        if (vertx.get() == null) {
            vertx.set(this.createVertx());
        }
        return new VertxClosingCloseable(vertx);
    }

    public DevServicesRestClientProxyProvider.CreateResult create(RestClientHttpProxyBuildItem buildItem) {
        URI baseUri = URI.create(buildItem.getBaseUri());
        HttpClientOptions clientOptions = new HttpClientOptions();
        if (baseUri.getScheme().equals("https")) {
            clientOptions.setSsl(true);
        }
        HttpClient proxyClient = vertx.get().createHttpClient(clientOptions);
        HttpProxy proxy = HttpProxy.reverseProxy((HttpClient)proxyClient);
        proxy.origin(this.determineOriginPort(baseUri), baseUri.getHost()).addInterceptor((ProxyInterceptor)new HostSettingInterceptor(baseUri.getHost()));
        HttpServer proxyServer = vertx.get().createHttpServer();
        Integer port = this.findRandomPort();
        proxyServer.requestHandler((Handler)proxy).listen(port.intValue());
        this.logStartup(buildItem.getClassName(), port);
        return new DevServicesRestClientProxyProvider.CreateResult("localhost", port, (Closeable)new HttpServerClosable(proxyServer));
    }

    protected void logStartup(String className, Integer port) {
        log.info((Object)("Started HTTP proxy server on http://localhost:" + port + " for REST Client '" + className + "'"));
    }

    private Vertx createVertx() {
        try (ResettableSystemProperties ignored = ResettableSystemProperties.of((String)"vertx.disableDnsResolver", (String)"true");){
            Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(false).setClassPathResolvingEnabled(false)).setMetricsOptions(new MetricsOptions().setEnabled(false)).setEventLoopPoolSize(2).setWorkerPoolSize(2).setInternalBlockingPoolSize(2));
            return vertx;
        }
    }

    private int determineOriginPort(URI baseUri) {
        if (baseUri.getPort() != -1) {
            return baseUri.getPort();
        }
        if (baseUri.getScheme().equals("https")) {
            return 443;
        }
        return 80;
    }

    private Integer findRandomPort() {
        Integer n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        socket.close();
        return n;
    }

    private static class VertxClosingCloseable
    implements Closeable {
        private final AtomicReference<Vertx> vertx;

        public VertxClosingCloseable(AtomicReference<Vertx> vertx) {
            this.vertx = vertx;
        }

        @Override
        public void close() {
            try {
                this.vertx.get().close().toCompletionStage().toCompletableFuture().join();
            }
            catch (Exception e) {
                log.debug((Object)"Error closing Vertx", (Throwable)e);
            }
            this.vertx.set(null);
        }
    }

    private static class HostSettingInterceptor
    implements ProxyInterceptor {
        private final String host;

        private HostSettingInterceptor(String host) {
            this.host = host;
        }

        public Future<ProxyResponse> handleProxyRequest(ProxyContext context) {
            ProxyRequest request = context.request();
            MultiMap headers = request.headers();
            headers.set("Host", this.host);
            return context.sendRequest();
        }
    }

    private static class HttpServerClosable
    implements Closeable {
        private final HttpServer server;

        public HttpServerClosable(HttpServer server) {
            this.server = server;
        }

        @Override
        public void close() throws IOException {
            try {
                this.server.close().toCompletionStage().toCompletableFuture().join();
            }
            catch (Exception e) {
                log.debug((Object)"Error closing HTTP Proxy server", (Throwable)e);
            }
        }
    }
}

