/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.JacksonUtil;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientMessageBodyWriter;
import org.jboss.resteasy.reactive.server.jackson.JacksonMessageBodyWriterUtil;

public class ClientJacksonMessageBodyWriter
implements ClientMessageBodyWriter<Object> {
    private final ObjectWriter defaultWriter;
    private final ConcurrentMap<ObjectMapper, ObjectWriter> objectWriterMap = new ConcurrentHashMap<ObjectMapper, ObjectWriter>();

    @Inject
    public ClientJacksonMessageBodyWriter(ObjectMapper mapper) {
        this.defaultWriter = JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)mapper);
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)this.getEffectiveWriter(mediaType, annotations, null));
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream, RestClientRequestContext context) throws IOException, WebApplicationException {
        JacksonMessageBodyWriterUtil.doLegacyWrite((Object)o, (Annotation[])annotations, httpHeaders, (OutputStream)entityStream, (ObjectWriter)this.getEffectiveWriter(mediaType, annotations, context));
    }

    protected ObjectWriter getEffectiveWriter(MediaType responseMediaType, Annotation[] annotations, RestClientRequestContext context) {
        ObjectWriter result = this.defaultWriter;
        ObjectMapper objectMapper = JacksonUtil.getObjectMapperFromContext(responseMediaType, context);
        if (objectMapper != null) {
            result = this.objectWriterMap.computeIfAbsent(objectMapper, new Function<ObjectMapper, ObjectWriter>(){

                @Override
                public ObjectWriter apply(ObjectMapper objectMapper) {
                    return JacksonMessageBodyWriterUtil.createDefaultWriter((ObjectMapper)objectMapper);
                }
            });
        }
        return ClientJacksonMessageBodyWriter.applyJsonViewIfPresent(result, this.effectiveView(annotations, context));
    }

    private Optional<Class<?>> effectiveView(Annotation[] annotations, RestClientRequestContext context) {
        Parameter[] parameters;
        Optional<Class<?>> fromAnnotations = JacksonUtil.matchingView(annotations);
        if (fromAnnotations.isPresent()) {
            return fromAnnotations;
        }
        if (context != null && context.getInvokedMethod() != null && (parameters = context.getInvokedMethod().getParameters()) != null) {
            for (Parameter parameter : parameters) {
                Annotation[] paramAnnotations = parameter.getAnnotations();
                boolean isBodyParameter = true;
                for (Annotation paramAnnotation : paramAnnotations) {
                    String paramTypeClassName = paramAnnotation.annotationType().getName();
                    if (!paramTypeClassName.startsWith("jakarta.ws.rs") && !paramTypeClassName.startsWith("io.quarkus.rest.client") && !paramTypeClassName.startsWith("org.jboss.resteasy.reactive")) continue;
                    isBodyParameter = false;
                    break;
                }
                if (!isBodyParameter) continue;
                return JacksonUtil.matchingView(paramAnnotations);
            }
        }
        return Optional.empty();
    }

    private static ObjectWriter applyJsonViewIfPresent(ObjectWriter writer, Optional<Class<?>> maybeView) {
        if (maybeView.isPresent()) {
            return writer.withView(maybeView.get());
        }
        return writer;
    }
}

