/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.IntFunction;

public class ToObjectArray {
    private static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    private static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    private static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    private static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    private static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    private static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    private static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];

    public static Object[] collection(Collection<?> collection) {
        return collection.toArray();
    }

    public static Object[] value(Object value) {
        return new Object[]{value};
    }

    public static Object[] optional(Optional<?> optional) {
        Object[] objectArray;
        if (optional.isPresent()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = optional.get();
        } else {
            objectArray = EMPTY_OBJECT_ARRAY;
        }
        return objectArray;
    }

    public static Boolean[] primitiveArray(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[array.length];
        return ToObjectArray.setAll(result, i -> array[i] ? Boolean.TRUE : Boolean.FALSE);
    }

    public static Byte[] primitiveArray(final byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        return ToObjectArray.setAll(new Byte[array.length], new IntFunction<Byte>(){

            @Override
            public Byte apply(int index) {
                return array[index];
            }
        });
    }

    public static Character[] primitiveArray(final char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        return ToObjectArray.setAll(new Character[array.length], new IntFunction<Character>(){

            @Override
            public Character apply(int index) {
                return Character.valueOf(array[index]);
            }
        });
    }

    public static Double[] primitiveArray(final double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return ToObjectArray.setAll(new Double[array.length], new IntFunction<Double>(){

            @Override
            public Double apply(int index) {
                return array[index];
            }
        });
    }

    public static Float[] primitiveArray(final float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        return ToObjectArray.setAll(new Float[array.length], new IntFunction<Float>(){

            @Override
            public Float apply(int index) {
                return Float.valueOf(array[index]);
            }
        });
    }

    public static Integer[] primitiveArray(final int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        return ToObjectArray.setAll(new Integer[array.length], new IntFunction<Integer>(){

            @Override
            public Integer apply(int index) {
                return array[index];
            }
        });
    }

    public static Long[] primitiveArray(final long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        return ToObjectArray.setAll(new Long[array.length], new IntFunction<Long>(){

            @Override
            public Long apply(int index) {
                return array[index];
            }
        });
    }

    public static Short[] primitiveArray(final short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        return ToObjectArray.setAll(new Short[array.length], new IntFunction<Short>(){

            @Override
            public Short apply(int index) {
                return array[index];
            }
        });
    }

    private static <T> T[] setAll(T[] array, IntFunction<? extends T> generator) {
        if (array != null && generator != null) {
            Arrays.setAll(array, generator);
        }
        return array;
    }

    private ToObjectArray() {
    }
}

