/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.ClientWebApplicationException;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.util.EmptyInputStream;
import org.jboss.resteasy.reactive.server.jackson.JacksonBasicMessageBodyReader;

public class ClientJacksonMessageBodyReader
extends JacksonBasicMessageBodyReader
implements ClientRestHandler {
    private static final Logger log = Logger.getLogger(ClientJacksonMessageBodyReader.class);
    private final ConcurrentMap<ObjectMapper, ObjectReader> contextResolverMap = new ConcurrentHashMap<ObjectMapper, ObjectReader>();
    private RestClientRequestContext context;

    @Inject
    public ClientJacksonMessageBodyReader(ObjectMapper mapper) {
        super(mapper);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            if (entityStream instanceof EmptyInputStream) {
                return null;
            }
            ObjectReader reader = this.getEffectiveReader(type, mediaType);
            return reader.forType(reader.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
        }
        catch (JsonParseException e) {
            log.debug((Object)"Server returned invalid json data", (Throwable)e);
            throw new ClientWebApplicationException((Throwable)e, Response.Status.OK);
        }
        catch (StreamReadException | DatabindException e) {
            throw new ClientWebApplicationException(e, Response.Status.BAD_REQUEST);
        }
    }

    public void handle(RestClientRequestContext requestContext) {
        this.context = requestContext;
    }

    private ObjectReader getEffectiveReader(Class<Object> type, MediaType responseMediaType) {
        ObjectMapper effectiveMapper = this.getObjectMapperFromContext(type, responseMediaType);
        if (effectiveMapper == null) {
            return this.getEffectiveReader();
        }
        return this.contextResolverMap.computeIfAbsent(effectiveMapper, new Function<ObjectMapper, ObjectReader>(){

            @Override
            public ObjectReader apply(ObjectMapper objectMapper) {
                return objectMapper.reader();
            }
        });
    }

    private ObjectMapper getObjectMapperFromContext(Class<Object> type, MediaType responseMediaType) {
        Providers providers = this.getProviders();
        if (providers == null) {
            return null;
        }
        ContextResolver contextResolver = providers.getContextResolver(ObjectMapper.class, responseMediaType);
        if (contextResolver == null) {
            contextResolver = providers.getContextResolver(ObjectMapper.class, null);
        }
        if (contextResolver != null) {
            return (ObjectMapper)contextResolver.getContext(type);
        }
        return null;
    }

    private Providers getProviders() {
        if (this.context != null && this.context.getClientRequestContext() != null) {
            return this.context.getClientRequestContext().getProviders();
        }
        return null;
    }
}

