package io.quarkus.resteasy.reactive.common.deployment;

import org.jboss.jandex.IndexView;

import io.quarkus.builder.item.SimpleBuildItem;

/**
 * Represents the index that is going to be used to look up JAX-RS Resources.
 * This index contains both code that is present on disk at build time,
 * and code that is generated by other extensions.
 */
public final class JaxRsResourceIndexBuildItem extends SimpleBuildItem {

    private final IndexView indexView;

    public JaxRsResourceIndexBuildItem(IndexView indexView) {
        this.indexView = indexView;
    }

    public IndexView getIndexView() {
        return indexView;
    }
}
