/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.deployment;

import io.quarkus.resteasy.reactive.links.RestLinkType;
import io.quarkus.resteasy.reactive.links.RestLinksHandler;
import io.quarkus.resteasy.reactive.links.deployment.DotNames;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.server.model.FixedHandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class LinksMethodScanner
implements MethodScanner {
    public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
        AnnotationValue restInstanceValue;
        AnnotationStore annotationStore = (AnnotationStore)methodContext.get("ANNOTATION_STORE");
        AnnotationInstance injectRestLinksInstance = this.getInjectRestLinksAnnotation(method, actualEndpointClass, annotationStore);
        if (injectRestLinksInstance == null) {
            return Collections.emptyList();
        }
        RestLinkType restLinkType = RestLinkType.TYPE;
        AnnotationValue injectRestLinksValue = injectRestLinksInstance.value();
        if (injectRestLinksValue != null) {
            restLinkType = RestLinkType.valueOf((String)injectRestLinksValue.asEnum());
        }
        AnnotationInstance restLinkInstance = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.REST_LINK_ANNOTATION);
        String entityType = null;
        if (restLinkInstance != null && (restInstanceValue = restLinkInstance.value("entityType")) != null) {
            entityType = restInstanceValue.asClass().name().toString();
        }
        RestLinksHandler handler = new RestLinksHandler();
        handler.setRestLinkData(new RestLinksHandler.RestLinkData(restLinkType, entityType));
        return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)handler, HandlerChainCustomizer.Phase.AFTER_RESPONSE_CREATED));
    }

    private AnnotationInstance getInjectRestLinksAnnotation(MethodInfo method, ClassInfo actualEndpointClass, AnnotationStore annotationStore) {
        AnnotationInstance annotationInstance = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.INJECT_REST_LINKS_ANNOTATION);
        if (annotationInstance == null && (annotationInstance = annotationStore.getAnnotation((AnnotationTarget)method.declaringClass(), DotNames.INJECT_REST_LINKS_ANNOTATION)) == null && !actualEndpointClass.equals(method.declaringClass())) {
            annotationInstance = annotationStore.getAnnotation((AnnotationTarget)actualEndpointClass, DotNames.INJECT_REST_LINKS_ANNOTATION);
        }
        return annotationInstance;
    }
}

