/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.deployment;

import java.util.Objects;
import org.jboss.jandex.FieldInfo;

class GetterMetadata {
    private static final String GETTER_PREFIX = "resteasy_links_get_";
    private static final String ACCESSOR_SUFFIX = "$_resteasy_links";
    private final String entityType;
    private final String fieldType;
    private final String fieldName;

    GetterMetadata(FieldInfo fieldInfo) {
        this.entityType = fieldInfo.declaringClass().toString();
        this.fieldType = fieldInfo.type().name().toString();
        this.fieldName = fieldInfo.name();
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getGetterName() {
        return GETTER_PREFIX + this.fieldName;
    }

    public String getGetterAccessorName() {
        return this.entityType + ACCESSOR_SUFFIX + this.getGetterName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetterMetadata that = (GetterMetadata)o;
        return this.entityType.equals(that.entityType) && this.fieldType.equals(that.fieldType) && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.fieldType, this.fieldName);
    }
}

