/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.runtime;

import io.quarkus.arc.ArcInvocationContext;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.client.ResponseProcessingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import org.jboss.resteasy.microprofile.client.ExceptionMapping;

public class QuarkusInvocationContextImpl
implements ArcInvocationContext {
    private final Object target;
    private final Method method;
    private Object[] args;
    private final int position;
    private final Map<String, Object> contextData;
    private final List<InterceptorInvocation> chain;
    private final Set<Annotation> interceptorBindings;

    public QuarkusInvocationContextImpl(Object target, Method method, Object[] args, List<InterceptorInvocation> chain, Set<Annotation> interceptorBindings) {
        this(target, method, args, chain, 0, interceptorBindings);
    }

    private QuarkusInvocationContextImpl(Object target, Method method, Object[] args, List<InterceptorInvocation> chain, int position, Set<Annotation> interceptorBindings) {
        this.target = target;
        this.method = method;
        this.args = args;
        this.interceptorBindings = interceptorBindings == null ? Collections.emptySet() : interceptorBindings;
        this.contextData = new HashMap<String, Object>();
        this.contextData.put("io.quarkus.arc.interceptorBindings", interceptorBindings);
        this.position = position;
        this.chain = chain;
    }

    boolean hasNextInterceptor() {
        return this.position < this.chain.size();
    }

    protected Object invokeNext() throws Exception {
        return this.chain.get(this.position).invoke(this.nextContext());
    }

    private InvocationContext nextContext() {
        return new QuarkusInvocationContextImpl(this.target, this.method, this.args, this.chain, this.position + 1, this.interceptorBindings);
    }

    protected Object interceptorChainCompleted() throws Exception {
        try {
            return this.method.invoke(this.target, this.args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                cause = cause.getCause();
            }
            if (cause instanceof ExceptionMapping.HandlerException) {
                ((ExceptionMapping.HandlerException)cause).mapException(this.method);
            }
            if (cause instanceof ResponseProcessingException) {
                ResponseProcessingException rpe = (ResponseProcessingException)cause;
                rpe.getResponse().close();
                cause = rpe.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
            }
            throw e;
        }
    }

    public Object proceed() throws Exception {
        try {
            if (this.hasNextInterceptor()) {
                return this.invokeNext();
            }
            return this.interceptorChainCompleted();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor<?> getConstructor() {
        return null;
    }

    public Object[] getParameters() throws IllegalStateException {
        return this.args;
    }

    public void setParameters(Object[] params) throws IllegalStateException, IllegalArgumentException {
        this.args = params;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Object getTimer() {
        return null;
    }

    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public <T extends Annotation> T findIterceptorBinding(Class<T> annotationType) {
        for (Annotation annotation : this.getInterceptorBindings()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)annotation;
        }
        return null;
    }

    public <T extends Annotation> List<T> findIterceptorBindings(Class<T> annotationType) {
        ArrayList<Annotation> found = new ArrayList<Annotation>();
        for (Annotation annotation : this.getInterceptorBindings()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            found.add(annotation);
        }
        return found;
    }

    public static class InterceptorInvocation {
        private final Interceptor interceptor;
        private final Object interceptorInstance;

        public InterceptorInvocation(Interceptor<?> interceptor, Object interceptorInstance) {
            this.interceptor = interceptor;
            this.interceptorInstance = interceptorInstance;
        }

        Object invoke(InvocationContext ctx) throws Exception {
            return this.interceptor.intercept(InterceptionType.AROUND_INVOKE, this.interceptorInstance, ctx);
        }
    }
}

