/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.common.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.resteasy.common.deployment.JaxrsProvidersToRegisterBuildItem;
import io.quarkus.resteasy.common.deployment.RestClientBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyJsonConfig;
import io.quarkus.resteasy.common.runtime.ResteasyCommonConfig;
import io.quarkus.resteasy.common.runtime.ResteasyInjectorFactoryRecorder;
import io.quarkus.resteasy.common.runtime.config.ResteasyConfigBuilder;
import io.quarkus.resteasy.common.runtime.providers.ServerFormUrlEncodedProvider;
import io.quarkus.resteasy.common.spi.ResteasyConfigBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.runtime.RuntimeValue;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.microprofile.config.FilterConfigSource;
import org.jboss.resteasy.microprofile.config.ServletConfigSource;
import org.jboss.resteasy.microprofile.config.ServletContextConfigSource;
import org.jboss.resteasy.plugins.interceptors.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.config.ConfigurationFactory;

public class ResteasyCommonProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)ResteasyCommonProcessor.class.getName());
    private static final ProviderDiscoverer[] PROVIDER_DISCOVERERS = new ProviderDiscoverer[]{new ProviderDiscoverer(ResteasyDotNames.GET, false, true), new ProviderDiscoverer(ResteasyDotNames.HEAD, false, false), new ProviderDiscoverer(ResteasyDotNames.DELETE, true, false), new ProviderDiscoverer(ResteasyDotNames.OPTIONS, false, true), new ProviderDiscoverer(ResteasyDotNames.PATCH, true, false), new ProviderDiscoverer(ResteasyDotNames.POST, true, true), new ProviderDiscoverer(ResteasyDotNames.PUT, true, false)};
    private static final DotName QUARKUS_OBJECT_MAPPER_CONTEXT_RESOLVER = DotName.createSimple((String)"io.quarkus.resteasy.common.runtime.jackson.QuarkusObjectMapperContextResolver");
    private static final DotName OBJECT_MAPPER = DotName.createSimple((String)"com.fasterxml.jackson.databind.ObjectMapper");
    private static final DotName QUARKUS_JACKSON_SERIALIZER = DotName.createSimple((String)"io.quarkus.resteasy.common.runtime.jackson.QuarkusJacksonSerializer");
    private static final DotName QUARKUS_JSONB_CONTEXT_RESOLVER = DotName.createSimple((String)"io.quarkus.resteasy.common.runtime.jsonb.QuarkusJsonbContextResolver");
    private static final DotName JSONB = DotName.createSimple((String)"jakarta.json.bind.Jsonb");
    private static final DotName QUARKUS_JSONB_SERIALIZER = DotName.createSimple((String)"io.quarkus.resteasy.common.runtime.jsonb.QuarkusJsonbSerializer");
    private static final String APPLICATION_HAL_JSON = "application/hal+json";
    private static final String[] WILDCARD_MEDIA_TYPE_ARRAY = new String[]{"*/*"};
    private ResteasyCommonConfig resteasyCommonConfig;

    @BuildStep
    void addStaticInitConfigSourceProvider(Capabilities capabilities, BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (!capabilities.isCapabilityWithPrefixPresent("io.quarkus.servlet")) {
            return;
        }
        staticInitConfigBuilder.produce((BuildItem)new StaticInitConfigBuilderBuildItem(ResteasyConfigBuilder.class));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ServletConfigSource.class, ServletContextConfigSource.class, FilterConfigSource.class}).reason(this.getClass().getName()).build());
    }

    @BuildStep
    ResteasyConfigBuildItem resteasyConfig(ResteasyJsonConfig resteasyJsonConfig, Capabilities capabilities) {
        return new ResteasyConfigBuildItem(resteasyJsonConfig.jsonDefault() && (capabilities.isCapabilityWithPrefixPresent("io.quarkus.resteasy.json.jackson") || capabilities.isCapabilityWithPrefixPresent("io.quarkus.resteasy.json.jsonb")));
    }

    @BuildStep
    void disableDefaultExceptionMapper(BuildProducer<SystemPropertyBuildItem> systemProperties) {
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem("dev.resteasy.exception.mapper", "false"));
    }

    @BuildStep
    void setupRestEasyManualProviders(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(ServerFormUrlEncodedProvider.class.getName()));
    }

    @BuildStep
    void setupGzipProviders(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        if (this.resteasyCommonConfig.gzip().enabled()) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(AcceptEncodingGZIPFilter.class.getName()));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(GZIPDecodingInterceptor.class.getName()));
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(GZIPEncodingInterceptor.class.getName()));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @Consume(value=BeanContainerBuildItem.class)
    @BuildStep
    ResteasyInjectionReadyBuildItem setupResteasyInjection(ResteasyInjectorFactoryRecorder recorder) {
        RuntimeValue injectorFactory = recorder.setup();
        return new ResteasyInjectionReadyBuildItem((RuntimeValue<InjectorFactory>)injectorFactory);
    }

    @BuildStep
    JaxrsProvidersToRegisterBuildItem setupProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem indexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, List<ResteasyJaxrsProviderBuildItem> contributedProviderBuildItems, List<RestClientBuildItem> restClients, ResteasyConfigBuildItem resteasyConfig, Capabilities capabilities) throws Exception {
        String needsMutinyClasses;
        HashSet<String> availableProviders = new HashSet<String>(ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + Providers.class.getName())));
        MediaTypeMap categorizedReaders = new MediaTypeMap();
        MediaTypeMap categorizedWriters = new MediaTypeMap();
        MediaTypeMap categorizedContextResolvers = new MediaTypeMap();
        HashSet<String> otherProviders = new HashSet<String>();
        ResteasyCommonProcessor.categorizeProviders(availableProviders, (MediaTypeMap<String>)categorizedReaders, (MediaTypeMap<String>)categorizedWriters, (MediaTypeMap<String>)categorizedContextResolvers, otherProviders);
        if (!capabilities.isPresent("io.quarkus.vertx") && !capabilities.isCapabilityWithPrefixPresent("io.quarkus.resteasy.json")) {
            boolean needJsonSupport;
            boolean bl = needJsonSupport = this.restJsonSupportNeeded(indexBuildItem, ResteasyDotNames.CONSUMES) || this.restJsonSupportNeeded(indexBuildItem, ResteasyDotNames.PRODUCES) || this.restJsonSupportNeeded(indexBuildItem, ResteasyDotNames.RESTEASY_SSE_ELEMENT_TYPE) || this.restJsonSupportNeeded(indexBuildItem, ResteasyDotNames.RESTEASY_PART_TYPE) || this.restJsonSupportNeededForHalCapability(capabilities, indexBuildItem);
            if (needJsonSupport) {
                LOGGER.warn((Object)"Quarkus detected the need of REST JSON support but you have not provided the necessary JSON extension for this. You can visit https://quarkus.io/guides/rest-json for more information on how to set one.");
            }
        }
        if (!capabilities.isPresent("io.quarkus.resteasy.mutiny") && (needsMutinyClasses = this.mutinySupportNeeded(indexBuildItem)) != null) {
            LOGGER.warn((Object)("Quarkus detected the need for Mutiny reactive programming support, however the quarkus-resteasy-mutiny extension was not present. Reactive REST endpoints in your application that return Uni or Multi will not function as you expect until you add this extension. Endpoints that need Mutiny are: " + needsMutinyClasses));
        }
        HashSet<String> providersToRegister = new HashSet<String>(otherProviders);
        providersToRegister.add(StringTextStar.class.getName());
        providersToRegister.addAll(categorizedWriters.getPossible(MediaType.APPLICATION_JSON_TYPE));
        IndexView index = indexBuildItem.getIndex();
        IndexView beansIndex = beanArchiveIndexBuildItem.getIndex();
        boolean useBuiltinProviders = ResteasyCommonProcessor.collectDeclaredProviders(restClients, resteasyConfig, providersToRegister, (MediaTypeMap<String>)categorizedReaders, (MediaTypeMap<String>)categorizedWriters, (MediaTypeMap<String>)categorizedContextResolvers, index, beansIndex);
        HashSet<String> contributedProviders = new HashSet<String>();
        for (ResteasyJaxrsProviderBuildItem resteasyJaxrsProviderBuildItem : contributedProviderBuildItems) {
            if (useBuiltinProviders && availableProviders.contains(resteasyJaxrsProviderBuildItem.getName())) continue;
            contributedProviders.add(resteasyJaxrsProviderBuildItem.getName());
        }
        HashSet<String> annotatedProviders = new HashSet<String>();
        for (AnnotationInstance i : indexBuildItem.getIndex().getAnnotations(ResteasyDotNames.PROVIDER)) {
            if (i.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            String annotatedProvider = i.target().asClass().name().toString();
            if (useBuiltinProviders && availableProviders.contains(annotatedProvider)) continue;
            annotatedProviders.add(annotatedProvider);
        }
        contributedProviders.addAll(annotatedProviders);
        providersToRegister.addAll(contributedProviders);
        if (useBuiltinProviders) {
            for (String availableProvider : availableProviders) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{availableProvider}).fields().build());
            }
        }
        if (providersToRegister.contains("org.jboss.resteasy.plugins.providers.jsonb.JsonBindingProvider")) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.jboss.resteasy.plugins.providers.jsonb.AbstractJsonBindingProvider"}).reason(this.getClass().getName()).methods().fields().build());
        }
        JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem = new JaxrsProvidersToRegisterBuildItem(providersToRegister, contributedProviders, annotatedProviders, useBuiltinProviders);
        unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(b -> result.getProviders().contains(b.getBeanClass().toString())));
        return jaxrsProvidersToRegisterBuildItem;
    }

    private String mutinySupportNeeded(CombinedIndexBuildItem indexBuildItem) {
        HashSet<DotName> mutinyTypes = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)"io.smallrye.mutiny.Uni"), DotName.createSimple((String)"io.smallrye.mutiny.Multi"), DotName.createSimple((String)"io.smallrye.mutiny.GroupedMulti")));
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (DotName annotation : ResteasyDotNames.JAXRS_METHOD_ANNOTATIONS) {
            for (AnnotationInstance instance : indexBuildItem.getIndex().getAnnotations(annotation)) {
                MethodInfo methodInfo = instance.target().asMethod();
                Type type = methodInfo.returnType();
                if (!mutinyTypes.contains(type.name())) continue;
                methods.add(methodInfo);
            }
        }
        if (methods.isEmpty()) {
            return null;
        }
        return methods.stream().map(new Function<MethodInfo, String>(){

            @Override
            public String apply(MethodInfo methodInfo) {
                return methodInfo.declaringClass().toString() + "{" + methodInfo.toString() + "}";
            }
        }).collect(Collectors.joining(", "));
    }

    @BuildStep
    void registerJsonContextResolvers(CombinedIndexBuildItem combinedIndexBuildItem, Capabilities capabilities, ResteasyJsonConfig resteasyJsonConfig, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProvider, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<UnremovableBeanBuildItem> unremovable) {
        if (capabilities.isCapabilityWithPrefixPresent("io.quarkus.resteasy.json.jackson")) {
            this.registerJsonContextResolver(OBJECT_MAPPER, QUARKUS_OBJECT_MAPPER_CONTEXT_RESOLVER, combinedIndexBuildItem, jaxrsProvider, additionalBean, unremovable);
            if (resteasyJsonConfig.jsonDefault()) {
                jaxrsProvider.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QUARKUS_JACKSON_SERIALIZER.toString()));
            }
        }
        if (capabilities.isCapabilityWithPrefixPresent("io.quarkus.resteasy.json.jsonb")) {
            this.registerJsonContextResolver(JSONB, QUARKUS_JSONB_CONTEXT_RESOLVER, combinedIndexBuildItem, jaxrsProvider, additionalBean, unremovable);
            if (resteasyJsonConfig.jsonDefault()) {
                jaxrsProvider.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QUARKUS_JSONB_SERIALIZER.toString()));
            }
        }
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ConfigurationFactory.class.getName()));
    }

    @BuildStep
    public RuntimeInitializedClassBuildItem runtimeInitResourceCleaner() {
        return new RuntimeInitializedClassBuildItem("org.jboss.resteasy.spi.ResourceCleaner");
    }

    private void registerJsonContextResolver(DotName jsonImplementation, DotName jsonContextResolver, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProvider, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<UnremovableBeanBuildItem> unremovable) {
        IndexView index = combinedIndexBuildItem.getIndex();
        jaxrsProvider.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(jsonContextResolver.toString()));
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)jsonContextResolver.toString()));
        Set<String> userSuppliedProducers = this.getUserSuppliedJsonProducerBeans(index, jsonImplementation);
        if (!userSuppliedProducers.isEmpty()) {
            unremovable.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNamesExclusion(userSuppliedProducers)));
        }
    }

    private Set<String> getUserSuppliedJsonProducerBeans(IndexView index, DotName jsonImplementation) {
        HashSet<String> result = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || !jsonImplementation.equals((Object)annotation.target().asMethod().returnType().name())) continue;
            result.add(annotation.target().asMethod().declaringClass().name().toString());
        }
        return result;
    }

    private boolean restJsonSupportNeededForHalCapability(Capabilities capabilities, CombinedIndexBuildItem indexBuildItem) {
        return capabilities.isPresent("io.quarkus.hal") && this.isMediaTypeFoundInAnnotation(indexBuildItem, ResteasyDotNames.PRODUCES, APPLICATION_HAL_JSON);
    }

    private boolean restJsonSupportNeeded(CombinedIndexBuildItem indexBuildItem, DotName mediaTypeAnnotation) {
        return this.isMediaTypeFoundInAnnotation(indexBuildItem, mediaTypeAnnotation, "application/json", "application/json-patch+json");
    }

    private boolean isMediaTypeFoundInAnnotation(CombinedIndexBuildItem indexBuildItem, DotName mediaTypeAnnotation, String ... mediaTypes) {
        for (AnnotationInstance annotationInstance : indexBuildItem.getIndex().getAnnotations(mediaTypeAnnotation)) {
            AnnotationValue annotationValue = annotationInstance.value();
            if (annotationValue == null) continue;
            List<Object> foundMediaTypes = Collections.emptyList();
            if (annotationValue.kind() == AnnotationValue.Kind.ARRAY) {
                foundMediaTypes = Arrays.asList(annotationValue.asStringArray());
            } else if (annotationValue.kind() == AnnotationValue.Kind.STRING) {
                foundMediaTypes = Collections.singletonList(annotationValue.asString());
            }
            for (int i = 0; i < mediaTypes.length; ++i) {
                if (!foundMediaTypes.contains(mediaTypes[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static void categorizeProviders(Set<String> availableProviders, MediaTypeMap<String> categorizedReaders, MediaTypeMap<String> categorizedWriters, MediaTypeMap<String> categorizedContextResolvers, Set<String> otherProviders) {
        for (String availableProvider : availableProviders) {
            try {
                Produces produces;
                Class<?> providerClass = Class.forName(availableProvider, false, Thread.currentThread().getContextClassLoader());
                if (MessageBodyReader.class.isAssignableFrom(providerClass) || MessageBodyWriter.class.isAssignableFrom(providerClass)) {
                    if (MessageBodyReader.class.isAssignableFrom(providerClass)) {
                        Consumes consumes = providerClass.getAnnotation(Consumes.class);
                        if (consumes != null) {
                            for (String consumesMediaType : consumes.value()) {
                                categorizedReaders.add(MediaType.valueOf((String)consumesMediaType), (Object)providerClass.getName());
                            }
                        } else {
                            categorizedReaders.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                        }
                    }
                    if (!MessageBodyWriter.class.isAssignableFrom(providerClass)) continue;
                    produces = providerClass.getAnnotation(Produces.class);
                    if (produces != null) {
                        for (String producesMediaType : produces.value()) {
                            categorizedWriters.add(MediaType.valueOf((String)producesMediaType), (Object)providerClass.getName());
                        }
                        continue;
                    }
                    categorizedWriters.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                    continue;
                }
                if (ContextResolver.class.isAssignableFrom(providerClass)) {
                    produces = providerClass.getAnnotation(Produces.class);
                    if (produces != null) {
                        for (String producesMediaType : produces.value()) {
                            categorizedContextResolvers.add(MediaType.valueOf((String)producesMediaType), (Object)providerClass.getName());
                        }
                        continue;
                    }
                    categorizedContextResolvers.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                    continue;
                }
                otherProviders.add(providerClass.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private static boolean collectDeclaredProviders(List<RestClientBuildItem> restClients, ResteasyConfigBuildItem resteasyConfig, Set<String> providersToRegister, MediaTypeMap<String> categorizedReaders, MediaTypeMap<String> categorizedWriters, MediaTypeMap<String> categorizedContextResolvers, IndexView ... indexes) {
        Set restClientNames = restClients.stream().map(RestClientBuildItem::getInterfaceName).collect(Collectors.toSet());
        for (IndexView index : indexes) {
            for (ProviderDiscoverer providerDiscoverer : PROVIDER_DISCOVERERS) {
                Collection getMethods = index.getAnnotations(providerDiscoverer.getMethodAnnotation());
                for (AnnotationInstance getMethod : getMethods) {
                    MethodInfo methodTarget = getMethod.target().asMethod();
                    boolean isRestClient = restClientNames.contains(methodTarget.declaringClass().name().toString());
                    if (isRestClient) {
                        if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedWriters, methodTarget, ResteasyDotNames.CONSUMES, providerDiscoverer.noConsumesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                            return true;
                        }
                        if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedReaders, methodTarget, ResteasyDotNames.PRODUCES, providerDiscoverer.noProducesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                            return true;
                        }
                    } else {
                        if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedReaders, methodTarget, ResteasyDotNames.CONSUMES, providerDiscoverer.noConsumesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                            return true;
                        }
                        if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedWriters, methodTarget, ResteasyDotNames.PRODUCES, providerDiscoverer.noProducesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                            return true;
                        }
                    }
                    if (ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedContextResolvers, methodTarget, ResteasyDotNames.CONSUMES, providerDiscoverer.noConsumesDefaultsToAll(), resteasyConfig.isJsonDefault())) {
                        return true;
                    }
                    if (!ResteasyCommonProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedContextResolvers, methodTarget, ResteasyDotNames.PRODUCES, providerDiscoverer.noProducesDefaultsToAll(), resteasyConfig.isJsonDefault())) continue;
                    return true;
                }
            }
            for (AnnotationInstance partTypeAnnotation : index.getAnnotations(ResteasyDotNames.RESTEASY_PART_TYPE)) {
                try {
                    MediaType partTypeMediaType = MediaType.valueOf((String)partTypeAnnotation.value().asString());
                    providersToRegister.addAll(categorizedReaders.getPossible(partTypeMediaType));
                    providersToRegister.addAll(categorizedWriters.getPossible(partTypeMediaType));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return false;
    }

    private static boolean collectDeclaredProvidersForMethodAndMediaTypeAnnotation(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, MethodInfo methodTarget, DotName mediaTypeAnnotation, boolean includeDefaults, boolean jsonDefault) {
        AnnotationInstance mediaTypeMethodAnnotationInstance = methodTarget.annotation(mediaTypeAnnotation);
        if (mediaTypeMethodAnnotationInstance == null) {
            AnnotationInstance mediaTypeClassAnnotationInstance = methodTarget.declaringClass().declaredAnnotation(mediaTypeAnnotation);
            if (mediaTypeClassAnnotationInstance != null) {
                AnnotationValue mediaTypeClassValue = mediaTypeClassAnnotationInstance.value();
                return mediaTypeClassValue != null && ResteasyCommonProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, mediaTypeClassValue.asStringArray(), methodTarget);
            }
            if (!includeDefaults) {
                return false;
            }
            if (jsonDefault) {
                ResteasyCommonProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, new String[]{"application/json"}, methodTarget);
                return false;
            }
            return true;
        }
        String[] mediaTypes = WILDCARD_MEDIA_TYPE_ARRAY;
        if (mediaTypeMethodAnnotationInstance.value() != null) {
            mediaTypes = mediaTypeMethodAnnotationInstance.value().asStringArray();
        }
        return ResteasyCommonProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, mediaTypes, methodTarget);
    }

    private static boolean collectDeclaredProvidersForMediaTypeAnnotationInstance(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, String[] mediaTypes, MethodInfo targetMethod) {
        for (String media : mediaTypes) {
            MediaType mediaType = MediaType.valueOf((String)media);
            if (MediaType.WILDCARD_TYPE.equals((Object)mediaType)) {
                return true;
            }
            providersToRegister.addAll(categorizedProviders.getPossible(mediaType));
            providersToRegister.addAll(ResteasyCommonProcessor.collectInferredProviders(mediaType, categorizedProviders, targetMethod));
        }
        return false;
    }

    private static Collection<String> collectInferredProviders(MediaType mediaType, MediaTypeMap<String> categorizedProviders, MethodInfo targetMethod) {
        if (ResteasyCommonProcessor.matches(MediaType.SERVER_SENT_EVENTS_TYPE, mediaType)) {
            HashSet<String> additionalProvidersToRegister = new HashSet<String>();
            AnnotationInstance sseElementTypeAnnInst = targetMethod.annotation(ResteasyDotNames.RESTEASY_SSE_ELEMENT_TYPE);
            String elementType = null;
            if (sseElementTypeAnnInst != null) {
                elementType = sseElementTypeAnnInst.value().asString();
            } else if (mediaType.getParameters() != null && mediaType.getParameters().containsKey("element-type")) {
                elementType = (String)mediaType.getParameters().get("element-type");
            }
            if (elementType != null) {
                additionalProvidersToRegister.addAll(categorizedProviders.getPossible(MediaType.valueOf((String)elementType)));
            } else {
                additionalProvidersToRegister.addAll(categorizedProviders.getPossible(MediaType.TEXT_PLAIN_TYPE));
            }
            return additionalProvidersToRegister;
        }
        return Collections.emptySet();
    }

    private static boolean matches(MediaType m1, MediaType m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.getType() == null || m1.getSubtype() == null) {
            return false;
        }
        return m1.getType().equalsIgnoreCase(m2.getType()) && m1.getSubtype().equalsIgnoreCase(m2.getSubtype());
    }

    private static class ProviderDiscoverer {
        private final DotName methodAnnotation;
        private final boolean noConsumesDefaultsToAll;
        private final boolean noProducesDefaultsToAll;

        private ProviderDiscoverer(DotName methodAnnotation, boolean noConsumesDefaultsToAll, boolean noProducesDefaultsToAll) {
            this.methodAnnotation = methodAnnotation;
            this.noConsumesDefaultsToAll = noConsumesDefaultsToAll;
            this.noProducesDefaultsToAll = noProducesDefaultsToAll;
        }

        public DotName getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public boolean noConsumesDefaultsToAll() {
            return this.noConsumesDefaultsToAll;
        }

        public boolean noProducesDefaultsToAll() {
            return this.noProducesDefaultsToAll;
        }
    }
}

