/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.common.runtime.config;

import jakarta.annotation.Priority;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.resteasy.spi.config.SizeUnit;
import org.jboss.resteasy.spi.config.Threshold;

@Priority(value=200)
public class ThresholdConverter
implements Converter<Threshold>,
Serializable {
    public static final Threshold NONE = Threshold.of((long)-1L, (SizeUnit)SizeUnit.BYTE);
    public static final Threshold DEFAULT = Threshold.of((long)512L, (SizeUnit)SizeUnit.KILOBYTE);
    private static final Pattern PATTERN = Pattern.compile("(?<size>-?(?!0)\\d+)\\s*(?<unit>(?:ZB|EB|TB|PB|GB|MB|KB|B)\\b)?");

    public Threshold convert(String value) {
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(value.toUpperCase(Locale.ROOT));
        if (!matcher.find()) {
            return DEFAULT;
        }
        String stringSize = matcher.group("size");
        String stringUnit = matcher.group("unit");
        if (stringSize == null || stringSize.isBlank()) {
            return DEFAULT;
        }
        long size = Long.parseLong(stringSize);
        if (size < 0L) {
            return NONE;
        }
        SizeUnit unit = null;
        for (SizeUnit u : SizeUnit.values()) {
            if (!u.abbreviation().equals(stringUnit)) continue;
            unit = u;
            break;
        }
        return Threshold.of((long)size, (SizeUnit)(unit == null ? SizeUnit.BYTE : unit));
    }
}

