/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.security.spi.SecurityTransformerUtils;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class DenyJaxRsTransformer
implements AnnotationsTransformer {
    private final ResteasyDeployment resteasyDeployment;

    public DenyJaxRsTransformer(ResteasyDeployment resteasyDeployment) {
        this.resteasyDeployment = resteasyDeployment;
    }

    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return kind == AnnotationTarget.Kind.CLASS;
    }

    public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
        ClassInfo classInfo = transformationContext.getTarget().asClass();
        if (this.requiresSyntheticDenyAll(classInfo)) {
            transformationContext.transform().add(SecurityTransformerUtils.DENY_ALL, new AnnotationValue[0]).done();
        }
    }

    public boolean requiresSyntheticDenyAll(ClassInfo classInfo) {
        return !SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)classInfo) && this.isJaxRsResource(classInfo);
    }

    private boolean isJaxRsResource(ClassInfo classInfo) {
        String className = classInfo.name().toString();
        return this.resteasyDeployment.getScannedResourceClasses().contains(className);
    }
}

