/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.security.deployment.SecurityProcessor;
import io.quarkus.security.deployment.SecurityTransformerUtils;
import io.quarkus.security.spi.runtime.MethodDescription;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class AdditionalRolesAllowedTransformer
implements AnnotationsTransformer {
    private final Set<MethodDescription> methods;
    private final AnnotationValue[] rolesAllowed;

    public AdditionalRolesAllowedTransformer(Collection<MethodDescription> methods, List<String> rolesAllowed) {
        this.methods = new HashSet<MethodDescription>(methods);
        this.rolesAllowed = (AnnotationValue[])rolesAllowed.stream().map(s -> AnnotationValue.createStringValue((String)"", (String)s)).toArray(AnnotationValue[]::new);
    }

    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return kind == AnnotationTarget.Kind.METHOD;
    }

    public void transform(AnnotationsTransformer.TransformationContext context) {
        MethodDescription method = SecurityProcessor.createMethodDescription(context.getTarget().asMethod());
        if (this.methods.contains(method)) {
            ((Transformation)context.transform().add(SecurityTransformerUtils.ROLES_ALLOWED, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])this.rolesAllowed)})).done();
        }
    }
}

