/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.jandex.DotName;

public final class ClassSecurityCheckStorageBuildItem
extends SimpleBuildItem {
    private final Map<DotName, Object> classNameToSecurityCheck;

    private ClassSecurityCheckStorageBuildItem(Map<DotName, Object> classNameToSecurityCheck) {
        Objects.requireNonNull(classNameToSecurityCheck);
        this.classNameToSecurityCheck = Map.copyOf(classNameToSecurityCheck);
    }

    public Object getSecurityCheck(DotName className) {
        return this.classNameToSecurityCheck.get(className);
    }

    public static final class ClassStorageBuilder {
        private final Map<DotName, Object> classNameToSecurityCheck = new HashMap<DotName, Object>();

        public ClassStorageBuilder addSecurityCheck(DotName className, Object securityCheck) {
            this.classNameToSecurityCheck.put(className, securityCheck);
            return this;
        }

        public ClassSecurityCheckStorageBuildItem build() {
            return new ClassSecurityCheckStorageBuildItem(this.classNameToSecurityCheck);
        }
    }
}

