/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.execution.SchemaPrinter;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;

public class SmallRyeGraphQLSchemaHandler
implements Handler<RoutingContext> {
    private static final String ALLOWED_METHODS = "GET, OPTIONS";
    private static final String CONTENT_TYPE = "text/plain; charset=UTF-8";
    private final SchemaPrinter schemaPrinter = new SchemaPrinter();

    public void handle(RoutingContext event) {
        HttpServerRequest request = event.request();
        HttpServerResponse response = event.response();
        GraphQLSchema graphQLSchema = (GraphQLSchema)CDI.current().select(GraphQLSchema.class, new Annotation[0]).get();
        String schemaString = this.schemaPrinter.print(graphQLSchema);
        if (request.method().equals((Object)HttpMethod.OPTIONS)) {
            response.headers().set(HttpHeaders.ALLOW, (CharSequence)ALLOWED_METHODS);
        } else if (request.method().equals((Object)HttpMethod.GET)) {
            response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE);
            response.end(Buffer.buffer((String)schemaString));
        } else {
            response.setStatusCode(405).end();
        }
    }
}

