/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.build.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.build.impl.JwtProviderImpl;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

class SmallRyeJwtBuildProcessor {
    private static final Logger log = Logger.getLogger((String)SmallRyeJwtBuildProcessor.class.getName());

    SmallRyeJwtBuildProcessor() {
    }

    @BuildStep
    void addClassesForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{SignatureAlgorithm.class, KeyEncryptionAlgorithm.class, JwtProviderImpl.class}).reason(this.getClass().getName()).methods().fields().build());
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void registerNativeImageResources(BuildProducer<NativeImageResourceBuildItem> nativeImageResource) {
        Config config = ConfigProvider.getConfig();
        this.registerKeyLocationResource(config, "smallrye.jwt.sign.key.location", nativeImageResource);
        this.registerKeyLocationResource(config, "smallrye.jwt.encrypt.key.location", nativeImageResource);
    }

    private void registerKeyLocationResource(Config config, String propertyName, BuildProducer<NativeImageResourceBuildItem> nativeImageResource) {
        Optional keyLocation = config.getOptionalValue(propertyName, String.class);
        if (keyLocation.isPresent() && ((String)keyLocation.get()).length() > 1 && (((String)keyLocation.get()).indexOf(58) < 0 || ((String)keyLocation.get()).startsWith("classpath:"))) {
            log.infof("Adding %s to native image", keyLocation.get());
            String location = ((String)keyLocation.get()).startsWith("/") ? ((String)keyLocation.get()).substring(1) : (String)keyLocation.get();
            nativeImageResource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{location}));
        }
    }
}

