/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.metrics.MetricsFactoryConsumerBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.smallrye.metrics.deployment.SmallRyeMetricsDotNames;
import io.quarkus.smallrye.metrics.deployment.jandex.JandexBeanInfoAdapter;
import io.quarkus.smallrye.metrics.deployment.jandex.JandexMemberInfoAdapter;
import io.quarkus.smallrye.metrics.deployment.spi.MetricBuildItem;
import io.quarkus.smallrye.metrics.deployment.spi.MetricsConfigurationBuildItem;
import io.quarkus.smallrye.metrics.runtime.MetadataHolder;
import io.quarkus.smallrye.metrics.runtime.SmallRyeMetricsRecorder;
import io.quarkus.smallrye.metrics.runtime.TagHolder;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.smallrye.metrics.MetricProducer;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRequestHandler;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.interceptors.ConcurrentGaugeInterceptor;
import io.smallrye.metrics.interceptors.CountedInterceptor;
import io.smallrye.metrics.interceptors.GaugeRegistrationInterceptor;
import io.smallrye.metrics.interceptors.MeteredInterceptor;
import io.smallrye.metrics.interceptors.MetricNameFactory;
import io.smallrye.metrics.interceptors.MetricsBinding;
import io.smallrye.metrics.interceptors.SimplyTimedInterceptor;
import io.smallrye.metrics.interceptors.TimedInterceptor;
import io.vertx.core.Handler;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeMetricsProcessor {
    static final Logger LOGGER = Logger.getLogger((String)"io.quarkus.smallrye.metrics.deployment.SmallRyeMetricsProcessor");
    SmallRyeMetricsConfig metrics;

    @BuildStep
    MetricsConfigurationBuildItem metricsConfigurationBuildItem() {
        return new MetricsConfigurationBuildItem(this.metrics.path);
    }

    @BuildStep
    MetricsCapabilityBuildItem metricsCapabilityBuildItem(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        if (this.metrics.extensionsEnabled) {
            return new MetricsCapabilityBuildItem("smallrye-metrics"::equals, nonApplicationRootPathBuildItem.resolvePath(this.metrics.path));
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createRoute(BuildProducer<RouteBuildItem> routes, SmallRyeMetricsRecorder recorder, NonApplicationRootPathBuildItem frameworkRoot, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, LaunchModeBuildItem launchModeBuildItem, BeanContainerBuildItem beanContainer) {
        if (launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.metrics.path));
        }
        routes.produce((BuildItem)frameworkRoot.routeBuilder().route(this.metrics.path + (this.metrics.path.endsWith("/") ? "*" : "/*")).handler((Handler)recorder.handler(frameworkRoot.resolvePath(this.metrics.path))).blockingRoute().build());
        routes.produce((BuildItem)frameworkRoot.routeBuilder().route(this.metrics.path).routeConfigKey("quarkus.smallrye-metrics.path").handler((Handler)recorder.handler(frameworkRoot.resolvePath(this.metrics.path))).displayOnNotFoundPage("Metrics").blockingRoute().build());
    }

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{MetricProducer.class, MetricNameFactory.class, GaugeRegistrationInterceptor.class, MeteredInterceptor.class, ConcurrentGaugeInterceptor.class, CountedInterceptor.class, TimedInterceptor.class, SimplyTimedInterceptor.class}));
        beans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{MetricsRequestHandler.class, MetricRegistries.class}).build());
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformBeanScope(final BeanArchiveIndexBuildItem index, final CustomScopeAnnotationsBuildItem scopes) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public int getPriority() {
                return 900;
            }

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (scopes.isScopeIn(ctx.getAnnotations())) {
                    return;
                }
                ClassInfo clazz = ctx.getTarget().asClass();
                if (!SmallRyeMetricsProcessor.this.isJaxRsEndpoint(clazz) && !SmallRyeMetricsProcessor.this.isJaxRsProvider(clazz)) {
                    while (clazz != null && clazz.superName() != null) {
                        Map annotations = clazz.annotationsMap();
                        if (annotations.containsKey(SmallRyeMetricsDotNames.GAUGE) || annotations.containsKey(SmallRyeMetricsDotNames.CONCURRENT_GAUGE) || annotations.containsKey(SmallRyeMetricsDotNames.COUNTED) || annotations.containsKey(SmallRyeMetricsDotNames.METERED) || annotations.containsKey(SmallRyeMetricsDotNames.SIMPLY_TIMED) || annotations.containsKey(SmallRyeMetricsDotNames.TIMED) || annotations.containsKey(SmallRyeMetricsDotNames.METRIC)) {
                            LOGGER.debugf("Found metrics business methods on a class %s with no scope defined - adding @Dependent", (Object)ctx.getTarget());
                            ((Transformation)ctx.transform().add(Dependent.class, new AnnotationValue[0])).done();
                            break;
                        }
                        clazz = index.getIndex().getClassByName(clazz.superName());
                    }
                }
            }
        });
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformers() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz = context.getTarget().asClass();
                if (clazz.name().toString().startsWith(GaugeRegistrationInterceptor.class.getPackage().getName())) {
                    return;
                }
                if (clazz.annotationsMap().containsKey(SmallRyeMetricsDotNames.GAUGE)) {
                    BuiltinScope beanScope = BuiltinScope.from((ClassInfo)clazz);
                    if (!(SmallRyeMetricsProcessor.this.isJaxRsEndpoint(clazz) || beanScope == null || beanScope.equals((Object)BuiltinScope.APPLICATION) || beanScope.equals((Object)BuiltinScope.SINGLETON))) {
                        LOGGER.warnf("Bean %s declares a org.eclipse.microprofile.metrics.annotation.Gauge but is of a scope that typically creates multiple instances. Gauges are forbidden on beans that create multiple instances, this will cause errors when constructing them. Please use annotated gauges only in beans with @ApplicationScoped or @Singleton scopes, or in JAX-RS endpoints.", (Object)clazz.name().toString());
                    }
                    ((Transformation)context.transform().add(MetricsBinding.class, new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void reflectiveMethodsWithGauges(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods) {
        for (AnnotationInstance annotation : beanArchiveIndex.getIndex().getAnnotations(SmallRyeMetricsDotNames.GAUGE)) {
            if (!annotation.target().kind().equals((Object)AnnotationTarget.Kind.METHOD)) continue;
            reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(annotation.target().asMethod()));
        }
    }

    @BuildStep
    AutoInjectAnnotationBuildItem autoInjectMetric() {
        return new AutoInjectAnnotationBuildItem(new DotName[]{SmallRyeMetricsDotNames.METRIC});
    }

    @BuildStep
    public FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SMALLRYE_METRICS);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(BeanContainerBuildItem beanContainerBuildItem, SmallRyeMetricsRecorder metrics, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        for (DotName metricsAnnotation : SmallRyeMetricsDotNames.METRICS_ANNOTATIONS) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{metricsAnnotation.toString()}));
        }
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{SmallRyeMetricsDotNames.METRICS_BINDING.toString()}));
        metrics.createRegistries(beanContainerBuildItem.getValue());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerBaseAndVendorMetrics(SmallRyeMetricsRecorder metrics, ShutdownContextBuildItem shutdown, SmallRyeMetricsConfig config) {
        if (config.micrometerCompatibility) {
            metrics.registerMicrometerJvmMetrics((ShutdownContext)shutdown);
        } else {
            metrics.registerBaseMetrics();
            metrics.registerVendorMetrics();
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void dropRegistriesAtShutdown(SmallRyeMetricsRecorder recorder, ShutdownContextBuildItem shutdown) {
        recorder.dropRegistriesAtShutdown((ShutdownContext)shutdown);
    }

    @BuildStep
    public void logCleanup(BuildProducer<LogCleanupFilterBuildItem> logCleanupFilter) {
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("io.smallrye.metrics.MetricsRegistryImpl", new String[]{"Register metric ["}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerMetricsFromAnnotatedMethods(SmallRyeMetricsRecorder metrics, BeanArchiveIndexBuildItem beanArchiveIndex, TransformedAnnotationsBuildItem transformedAnnotations, ValidationPhaseBuildItem validationPhase) {
        IndexView index = beanArchiveIndex.getIndex();
        JandexBeanInfoAdapter beanInfoAdapter = new JandexBeanInfoAdapter(index, transformedAnnotations);
        JandexMemberInfoAdapter memberInfoAdapter = new JandexMemberInfoAdapter(index, transformedAnnotations);
        HashSet<MethodInfo> collectedMetricsMethods = new HashSet<MethodInfo>();
        HashMap<DotName, ClassInfo> collectedMetricsClasses = new HashMap<DotName, ClassInfo>();
        HashSet<DotName> metricAndStereotypeAnnotations = new HashSet<DotName>();
        metricAndStereotypeAnnotations.addAll(SmallRyeMetricsDotNames.METRICS_ANNOTATIONS);
        for (ClassInfo candidate : beanArchiveIndex.getIndex().getKnownClasses()) {
            if (transformedAnnotations.getAnnotation((AnnotationTarget)candidate, DotNames.STEREOTYPE) == null || !transformedAnnotations.getAnnotations((AnnotationTarget)candidate).stream().anyMatch(SmallRyeMetricsDotNames::isMetricAnnotation)) continue;
            metricAndStereotypeAnnotations.add(candidate.name());
        }
        validationPhase.getContext().beans().classBeans().filter(this::hasMetricsInterceptorAssociated).forEach(b -> this.collectMetricsClassAndSubClasses(index, collectedMetricsClasses, ((AnnotationTarget)b.getTarget().get()).asClass()));
        for (DotName metricAnnotation : metricAndStereotypeAnnotations) {
            Collection metricAnnotationInstances = index.getAnnotations(metricAnnotation);
            for (AnnotationInstance metricAnnotationInstance : metricAnnotationInstances) {
                AnnotationTarget metricAnnotationTarget = metricAnnotationInstance.target();
                switch (metricAnnotationTarget.kind()) {
                    case METHOD: {
                        MethodInfo method = metricAnnotationTarget.asMethod();
                        if (method.declaringClass().name().toString().startsWith("io.smallrye.metrics")) break;
                        if (!Modifier.isPrivate(method.flags())) {
                            collectedMetricsMethods.add(method);
                            break;
                        }
                        LOGGER.warn((Object)("Private method is annotated with a metric: " + method + " in class " + method.declaringClass().name() + ". Metrics are not collected for private methods. To enable metrics for this method, make it at least package-private."));
                        break;
                    }
                    case CLASS: {
                        ClassInfo clazz = metricAnnotationTarget.asClass();
                        if (clazz.name().toString().startsWith("io.smallrye.metrics")) break;
                        this.collectMetricsClassAndSubClasses(index, collectedMetricsClasses, clazz);
                        break;
                    }
                }
            }
        }
        for (ClassInfo clazz : collectedMetricsClasses.values()) {
            BeanInfo beanInfo = beanInfoAdapter.convert(clazz);
            ClassInfo superclass = clazz;
            HashSet<String> alreadyRegisteredNames = new HashSet<String>();
            while (superclass != null && superclass.superName() != null) {
                for (MethodInfo method : superclass.methods()) {
                    if (Modifier.isPrivate(method.flags()) || alreadyRegisteredNames.contains(method.toString())) continue;
                    metrics.registerMetrics(beanInfo, memberInfoAdapter.convert((AnnotationTarget)method));
                    alreadyRegisteredNames.add(method.toString());
                }
                superclass = index.getClassByName(superclass.superName());
            }
            superclass = clazz;
            while (superclass != null && superclass.superName() != null) {
                for (Type interfaceType : superclass.interfaceTypes()) {
                    ClassInfo ifaceInfo = beanArchiveIndex.getIndex().getClassByName(interfaceType.name());
                    if (ifaceInfo == null) continue;
                    this.findNonOverriddenDefaultMethods(ifaceInfo, alreadyRegisteredNames, metrics, beanArchiveIndex, memberInfoAdapter, beanInfo);
                }
                superclass = index.getClassByName(superclass.superName());
            }
        }
        for (MethodInfo method : collectedMetricsMethods) {
            ClassInfo declaringClazz = method.declaringClass();
            if (collectedMetricsClasses.containsKey(declaringClazz.name())) continue;
            BeanInfo beanInfo = beanInfoAdapter.convert(declaringClazz);
            metrics.registerMetrics(beanInfo, memberInfoAdapter.convert((AnnotationTarget)method));
        }
    }

    private boolean hasMetricsInterceptorAssociated(io.quarkus.arc.processor.BeanInfo bean) {
        if (!bean.hasAroundInvokeInterceptors()) {
            return false;
        }
        for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
            if (!interceptor.getBeanClass().toString().startsWith("io.smallrye.metrics.interceptors")) continue;
            return true;
        }
        return false;
    }

    private void findNonOverriddenDefaultMethods(ClassInfo interfaceInfo, Set<String> alreadyRegisteredNames, SmallRyeMetricsRecorder recorder, BeanArchiveIndexBuildItem beanArchiveIndex, JandexMemberInfoAdapter memberInfoAdapter, BeanInfo beanInfo) {
        for (MethodInfo method : interfaceInfo.methods()) {
            if (Modifier.isAbstract(method.flags()) || alreadyRegisteredNames.contains(method.toString())) continue;
            recorder.registerMetrics(beanInfo, memberInfoAdapter.convert((AnnotationTarget)method));
            alreadyRegisteredNames.add(method.toString());
        }
        for (Type extendedInterface : interfaceInfo.interfaceTypes()) {
            ClassInfo extendedInterfaceInfo = beanArchiveIndex.getIndex().getClassByName(extendedInterface.name());
            if (extendedInterfaceInfo == null) continue;
            this.findNonOverriddenDefaultMethods(extendedInterfaceInfo, alreadyRegisteredNames, recorder, beanArchiveIndex, memberInfoAdapter, beanInfo);
        }
    }

    @BuildStep
    void unremovableProducers(BuildProducer<UnremovableBeanBuildItem> unremovable) {
        final Type type = Type.create((DotName)SmallRyeMetricsDotNames.METRIC_INTERFACE, (Type.Kind)Type.Kind.CLASS);
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new Predicate<io.quarkus.arc.processor.BeanInfo>(){

            @Override
            public boolean test(io.quarkus.arc.processor.BeanInfo beanInfo) {
                io.quarkus.arc.processor.BeanInfo declaringBean = beanInfo.getDeclaringBean();
                return (beanInfo.isProducerMethod() || beanInfo.isProducerField()) && beanInfo.getTypes().contains(type) && !declaringBean.getBeanClass().toString().startsWith("io.smallrye.metrics");
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    void registerRuntimeExtensionMetrics(SmallRyeMetricsRecorder recorder, List<MetricsFactoryConsumerBuildItem> metricsFactoryConsumerBuildItems) {
        for (MetricsFactoryConsumerBuildItem item : metricsFactoryConsumerBuildItems) {
            if (item.executionTime() != ExecutionTime.RUNTIME_INIT) continue;
            recorder.registerMetrics(item.getConsumer());
        }
    }

    @BuildStep
    public void warnAboutMetricsFromProducers(ValidationPhaseBuildItem validationPhase, BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> unused) {
        for (io.quarkus.arc.processor.BeanInfo bean : validationPhase.getContext().beans().producers()) {
            MetricType metricType;
            ClassInfo implClazz = bean.getImplClazz();
            if (implClazz == null || (metricType = this.getMetricType(implClazz)) == null) continue;
            AnnotationTarget target = (AnnotationTarget)bean.getTarget().get();
            AnnotationInstance metricAnnotation = null;
            if (bean.isProducerField()) {
                FieldInfo field = target.asField();
                metricAnnotation = field.annotation(SmallRyeMetricsDotNames.METRIC);
            }
            if (bean.isProducerMethod()) {
                MethodInfo method = target.asMethod();
                metricAnnotation = method.annotation(SmallRyeMetricsDotNames.METRIC);
            }
            if (metricAnnotation == null) continue;
            LOGGER.warn((Object)("Metrics created from CDI producers are no longer supported. There will be no metric automatically registered for producer " + target));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void extensionMetrics(SmallRyeMetricsRecorder recorder, List<MetricBuildItem> additionalMetrics, List<MetricsFactoryConsumerBuildItem> metricsFactoryConsumerBuildItems, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        if (this.metrics.extensionsEnabled) {
            if (!additionalMetrics.isEmpty()) {
                unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(MetricRegistry.class.getName())));
                unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(MetricRegistries.class.getName())));
            }
            for (MetricBuildItem additionalMetric : additionalMetrics) {
                if (!additionalMetric.isEnabled()) continue;
                TagHolder[] tags = (TagHolder[])Arrays.stream(additionalMetric.getTags()).map(TagHolder::from).toArray(TagHolder[]::new);
                recorder.registerMetric(additionalMetric.getRegistryType(), MetadataHolder.from((Metadata)additionalMetric.getMetadata()), tags, additionalMetric.getImplementor());
            }
            for (MetricsFactoryConsumerBuildItem item : metricsFactoryConsumerBuildItems) {
                if (item.executionTime() != ExecutionTime.STATIC_INIT) continue;
                recorder.registerMetrics(item.getConsumer());
            }
        }
    }

    private MetricType getMetricType(ClassInfo clazz) {
        DotName name = clazz.name();
        if (name.equals((Object)SmallRyeMetricsDotNames.GAUGE_INTERFACE)) {
            return MetricType.GAUGE;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.COUNTER_INTERFACE)) {
            return MetricType.COUNTER;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.CONCURRENT_GAUGE_INTERFACE)) {
            return MetricType.CONCURRENT_GAUGE;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.HISTOGRAM_INTERFACE)) {
            return MetricType.HISTOGRAM;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.SIMPLE_TIMER_INTERFACE)) {
            return MetricType.SIMPLE_TIMER;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.TIMER_INTERFACE)) {
            return MetricType.TIMER;
        }
        if (name.equals((Object)SmallRyeMetricsDotNames.METER_INTERFACE)) {
            return MetricType.METERED;
        }
        return null;
    }

    private void collectMetricsClassAndSubClasses(IndexView index, Map<DotName, ClassInfo> collectedMetricsClasses, ClassInfo clazz) {
        if (collectedMetricsClasses.containsKey(clazz.name())) {
            return;
        }
        collectedMetricsClasses.put(clazz.name(), clazz);
        for (ClassInfo subClass : index.getAllKnownSubclasses(clazz.name())) {
            collectedMetricsClasses.put(subClass.name(), subClass);
        }
    }

    private boolean isJaxRsEndpoint(ClassInfo clazz) {
        return clazz.annotationsMap().containsKey(SmallRyeMetricsDotNames.JAXRS_PATH) || clazz.annotationsMap().containsKey(SmallRyeMetricsDotNames.REST_CONTROLLER);
    }

    private boolean isJaxRsProvider(ClassInfo clazz) {
        return clazz.annotationsMap().containsKey(SmallRyeMetricsDotNames.JAXRS_PROVIDER);
    }

    @ConfigRoot(name="smallrye-metrics")
    static final class SmallRyeMetricsConfig {
        @ConfigItem(defaultValue="metrics")
        String path;
        @ConfigItem(name="extensions.enabled", defaultValue="true")
        public boolean extensionsEnabled;
        @ConfigItem(name="micrometer.compatibility")
        public boolean micrometerCompatibility;
        @ConfigItem(name="jaxrs.enabled", defaultValue="false")
        public boolean jaxrsEnabled;

        SmallRyeMetricsConfig() {
        }
    }
}

