/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import io.quarkus.smallrye.openapi.deployment.filter.ClassAndMethod;
import io.smallrye.openapi.api.models.OperationImpl;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;

public class AutoTagFilter
implements OASFilter {
    private Map<String, ClassAndMethod> classNameMap;

    public AutoTagFilter() {
    }

    public AutoTagFilter(Map<String, ClassAndMethod> classNameMap) {
        this.classNameMap = classNameMap;
    }

    public Map<String, ClassAndMethod> getClassNameMap() {
        return this.classNameMap;
    }

    public void setClassNameMap(Map<String, ClassAndMethod> classNameMap) {
        this.classNameMap = classNameMap;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        Map pathItems;
        Paths paths;
        if (!this.classNameMap.isEmpty() && (paths = openAPI.getPaths()) != null && (pathItems = paths.getPathItems()) != null && !pathItems.isEmpty()) {
            Set pathItemsEntries = pathItems.entrySet();
            for (Map.Entry pathItem : pathItemsEntries) {
                Map operations = ((PathItem)pathItem.getValue()).getOperations();
                if (operations == null || operations.isEmpty()) continue;
                for (Operation operation : operations.values()) {
                    OperationImpl operationImpl;
                    String methodRef;
                    if ((operation.getDescription() == null || operation.getDescription().isBlank()) && this.classNameMap.containsKey(methodRef = (operationImpl = (OperationImpl)operation).getMethodRef())) {
                        operation.setDescription(this.capitalizeFirstLetter(this.splitCamelCase(this.classNameMap.get(methodRef).methodName())));
                    }
                    if (operation.getTags() != null && !operation.getTags().isEmpty() || !this.classNameMap.containsKey(methodRef = (operationImpl = (OperationImpl)operation).getMethodRef())) continue;
                    operation.addTag(this.splitCamelCase(this.classNameMap.get(methodRef).className()));
                }
            }
        }
    }

    private String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    private String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

