/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.kafka.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.smallrye.reactivemessaging.kafka.KafkaCodecDependencyRemovalLogger;
import io.vertx.kafka.client.serialization.BufferDeserializer;
import io.vertx.kafka.client.serialization.BufferSerializer;
import io.vertx.kafka.client.serialization.JsonArrayDeserializer;
import io.vertx.kafka.client.serialization.JsonArraySerializer;
import io.vertx.kafka.client.serialization.JsonObjectDeserializer;
import io.vertx.kafka.client.serialization.JsonObjectSerializer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class KafkaCodecProcessor {
    static final Class<?>[] VERTX_KAFKA_CLIENT_SERDES = new Class[]{JsonObjectSerializer.class, BufferSerializer.class, JsonArraySerializer.class, JsonObjectDeserializer.class, BufferDeserializer.class, JsonArrayDeserializer.class};

    @BuildStep
    public void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (Class<?> s : VERTX_KAFKA_CLIENT_SERDES) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{s.getName()}));
        }
    }

    @BuildStep
    public void deprecateVertxProvidedSerde(BuildProducer<BytecodeTransformerBuildItem> producer) {
        for (Class<?> vertxSerdeClass : VERTX_KAFKA_CLIENT_SERDES) {
            producer.produce((BuildItem)new BytecodeTransformerBuildItem(vertxSerdeClass.getName(), KafkaCodecDeprecateClassVisitor::new));
        }
    }

    private static class KafkaCodecDeprecateClassVisitor
    extends ClassVisitor {
        private final String fqcn;

        protected KafkaCodecDeprecateClassVisitor(String fqcn, ClassVisitor classVisitor) {
            super(589824, classVisitor);
            this.fqcn = fqcn;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("<init>")) {
                return new MethodVisitor(589824, methodVisitor){

                    public void visitCode() {
                        super.visitCode();
                        this.visitLdcInsn(fqcn);
                        this.visitMethodInsn(184, KafkaCodecDependencyRemovalLogger.class.getName().replace(".", "/"), "logDependencyRemoval", "(Ljava/lang/String;)V", false);
                    }
                };
            }
            return methodVisitor;
        }
    }
}

