/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.restclient.runtime;

import io.smallrye.restclient.header.ClientHeaderProvider;
import io.smallrye.restclient.header.ClientHeaderProviders;
import io.smallrye.restclient.header.HttpHeadersContextProvider;
import io.smallrye.restclient.header.IncomingHeadersProvider;
import io.smallrye.restclient.utils.ClientRequestContextUtils;
import io.smallrye.restclient.utils.ListCastUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.jboss.resteasy.core.ResteasyContext;

@Priority(value=-2147483648)
public class ClientHeadersRequestFilter
implements ClientRequestFilter {
    private static final IncomingHeadersProvider noIncomingHeadersProvider = MultivaluedHashMap::new;
    private static final IncomingHeadersProvider incomingHeadersProvider = ClientHeadersRequestFilter.initializeProvider();

    private static IncomingHeadersProvider initializeProvider() {
        ServiceLoader<IncomingHeadersProvider> providerLoader = ServiceLoader.load(IncomingHeadersProvider.class);
        Iterator<IncomingHeadersProvider> providers = providerLoader.iterator();
        if (!providers.hasNext()) {
            return noIncomingHeadersProvider;
        }
        IncomingHeadersProvider result = providers.next();
        if (providers.hasNext()) {
            throw new RuntimeException("Multiple " + IncomingHeadersProvider.class.getCanonicalName() + "'s registered, expecting at most one.");
        }
        return result;
    }

    public void filter(ClientRequestContext requestContext) {
        Method method = ClientRequestContextUtils.getMethod((ClientRequestContext)requestContext);
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Optional handler = ClientHeaderProviders.getProvider((Method)method);
        handler.ifPresent(arg_0 -> ClientHeadersRequestFilter.lambda$filter$0((MultivaluedMap)headers, arg_0));
        Optional factory = ClientHeaderProviders.getFactory(method.getDeclaringClass());
        requestContext.getHeaders().forEach((arg_0, arg_1) -> ClientHeadersRequestFilter.lambda$filter$1((MultivaluedMap)headers, arg_0, arg_1));
        factory.map(arg_0 -> this.lambda$filter$2((MultivaluedMap)headers, arg_0)).orElse((MultivaluedMap)headers).forEach((key, values) -> {
            List cfr_ignored_0 = (List)requestContext.getHeaders().put(key, ClientHeadersRequestFilter.castToListOfObjects(values));
        });
        ResteasyContext.getContextDataMap().put(HttpHeaders.class, new HttpHeadersContextProvider(requestContext));
    }

    private MultivaluedMap<String, String> updateHeaders(MultivaluedMap<String, String> headers, ClientHeadersFactory factory) {
        return factory.update(incomingHeadersProvider.getIncomingHeaders(), headers);
    }

    private static List<Object> castToListOfObjects(List<String> values) {
        return new ArrayList<Object>(values);
    }

    private /* synthetic */ MultivaluedMap lambda$filter$2(MultivaluedMap headers, ClientHeadersFactory f) {
        return this.updateHeaders((MultivaluedMap<String, String>)headers, f);
    }

    private static /* synthetic */ void lambda$filter$1(MultivaluedMap headers, String key, List values) {
        List cfr_ignored_0 = (List)headers.put((Object)key, (Object)ListCastUtils.castToListOfStrings((List)values));
    }

    private static /* synthetic */ void lambda$filter$0(MultivaluedMap headers, ClientHeaderProvider h) {
        h.addHeaders(headers);
    }
}

