/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.restclient.runtime;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class RestClientBase {
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    private final Class<?> proxyType;
    private final Config config;

    public RestClientBase(Class<?> proxyType) {
        this.proxyType = proxyType;
        this.config = ConfigProvider.getConfig();
    }

    public Object create() {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        String baseUrl = this.getBaseUrl();
        try {
            return builder.baseUrl(new URL(baseUrl)).build(this.proxyType);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The value of URL was invalid " + baseUrl);
        }
        catch (Exception e) {
            if ("com.oracle.svm.core.jdk.UnsupportedFeatureError".equals(e.getClass().getCanonicalName())) {
                throw new IllegalArgumentException(baseUrl + " requires SSL support but it is disabled. You probably have set quarkus.ssl.native to false.");
            }
            throw e;
        }
    }

    private String getBaseUrl() {
        String property = String.format(REST_URL_FORMAT, this.proxyType.getName());
        return (String)this.config.getValue(property, String.class);
    }
}

