/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.boot.properties.deployment;

import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.runtime.util.StringUtil;
import io.quarkus.spring.boot.properties.deployment.ConfigPropertyBuildItemCandidate;
import io.quarkus.spring.boot.properties.deployment.ConfigPropertyBuildItemCandidateUtil;
import io.quarkus.spring.boot.properties.deployment.ConfigurationPropertiesMetadataBuildItem;
import io.quarkus.spring.boot.properties.deployment.ConfigurationPropertiesProcessor;
import io.quarkus.spring.boot.properties.deployment.ConfigurationPropertiesUtil;
import io.quarkus.spring.boot.properties.deployment.DotNames;
import io.quarkus.spring.boot.properties.deployment.YamlListObjectHandler;
import io.smallrye.config.ConfigMapping;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.inject.Inject;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

final class ClassConfigurationPropertiesUtil {
    private static final Logger LOGGER = Logger.getLogger(ClassConfigurationPropertiesUtil.class);
    private static final String VALIDATOR_CLASS = "jakarta.validation.Validator";
    private static final String HIBERNATE_VALIDATOR_IMPL_CLASS = "org.hibernate.validator.HibernateValidator";
    private static final String CONSTRAINT_VIOLATION_EXCEPTION_CLASS = "jakarta.validation.ConstraintViolationException";
    private final IndexView applicationIndex;
    private final YamlListObjectHandler yamlListObjectHandler;
    private final ClassCreator producerClassCreator;
    private final Capabilities capabilities;
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClasses;
    private final BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods;
    private final BuildProducer<ConfigPropertyBuildItem> configProperties;

    ClassConfigurationPropertiesUtil(IndexView applicationIndex, YamlListObjectHandler yamlListObjectHandler, ClassCreator producerClassCreator, Capabilities capabilities, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ConfigPropertyBuildItem> configProperties) {
        this.applicationIndex = applicationIndex;
        this.yamlListObjectHandler = yamlListObjectHandler;
        this.producerClassCreator = producerClassCreator;
        this.capabilities = capabilities;
        this.reflectiveClasses = reflectiveClasses;
        this.reflectiveMethods = reflectiveMethods;
        this.configProperties = configProperties;
    }

    static void generateStartupObserverThatInjectsConfigClass(ClassOutput classOutput, Set<DotName> configClasses) {
        try (ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className("io.quarkus.spring.boot.properties.runtime.config.ConfigPropertiesObserver").build();){
            classCreator.addAnnotation(Dependent.class);
            HashMap<DotName, FieldDescriptor> configClassToFieldDescriptor = new HashMap<DotName, FieldDescriptor>(configClasses.size());
            for (DotName configClass : configClasses) {
                String configClassStr = configClass.toString();
                FieldCreator fieldCreator = (FieldCreator)classCreator.getFieldCreator((String)(configClass.isInner() ? configClass.local() : configClass.withoutPackagePrefix() + "_" + HashUtil.sha1((String)configClassStr)), configClassStr).setModifiers(1);
                fieldCreator.addAnnotation(Inject.class);
                configClassToFieldDescriptor.put(configClass, fieldCreator.getFieldDescriptor());
            }
            try (MethodCreator methodCreator = classCreator.getMethodCreator("onStartup", Void.TYPE, new Class[]{StartupEvent.class});){
                methodCreator.getParameterAnnotations(0).addAnnotation(Observes.class);
                for (DotName configClass : configClasses) {
                    ResultHandle field = methodCreator.readInstanceField((FieldDescriptor)configClassToFieldDescriptor.get(configClass), methodCreator.getThis());
                    methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((String)configClass.toString(), (String)"toString", (String)String.class.getName(), (String[])new String[0]), field, new ResultHandle[0]);
                }
                methodCreator.returnValue(null);
            }
        }
    }

    boolean addProducerMethodForClassConfigProperties(ClassLoader classLoader, ClassInfo configPropertiesClassInfo, String prefixStr, ConfigMapping.NamingStrategy namingStrategy, boolean failOnMismatchingMember, ConfigurationPropertiesMetadataBuildItem.InstanceFactory instanceFactory) {
        if (instanceFactory == null && !configPropertiesClassInfo.hasNoArgsConstructor()) {
            throw new IllegalArgumentException("Class " + configPropertiesClassInfo + " which is annotated with " + ConfigurationPropertiesProcessor.CONFIGURATION_PROPERTIES + " must contain a no-arg constructor");
        }
        String configObjectClassStr = configPropertiesClassInfo.name().toString();
        boolean needsValidation = ClassConfigurationPropertiesUtil.needsValidation();
        String[] produceMethodParameterTypes = new String[needsValidation ? 2 : 1];
        produceMethodParameterTypes[0] = Config.class.getName();
        if (needsValidation) {
            produceMethodParameterTypes[1] = VALIDATOR_CLASS;
        }
        String methodName = "produce" + configPropertiesClassInfo.name().withoutPackagePrefix();
        try (MethodCreator methodCreator = this.producerClassCreator.getMethodCreator(methodName, configObjectClassStr, produceMethodParameterTypes);){
            methodCreator.addAnnotation(Produces.class);
            ResultHandle configObject = this.populateConfigObject(classLoader, configPropertiesClassInfo, prefixStr, namingStrategy, failOnMismatchingMember, instanceFactory, methodCreator);
            if (needsValidation) {
                ClassConfigurationPropertiesUtil.createValidationCodePath(methodCreator, configObject, prefixStr);
            } else {
                methodCreator.returnValue(configObject);
            }
        }
        return needsValidation;
    }

    private static boolean needsValidation() {
        return ClassConfigurationPropertiesUtil.isHibernateValidatorInClasspath();
    }

    private static boolean isHibernateValidatorInClasspath() {
        try {
            Class.forName(HIBERNATE_VALIDATOR_IMPL_CLASS, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private ResultHandle populateConfigObject(ClassLoader classLoader, ClassInfo configClassInfo, String prefixStr, ConfigMapping.NamingStrategy namingStrategy, boolean failOnMismatchingMember, ConfigurationPropertiesMetadataBuildItem.InstanceFactory instanceFactory, MethodCreator methodCreator) {
        String configObjectClassStr = configClassInfo.name().toString();
        ResultHandle configObject = instanceFactory == null ? methodCreator.newInstance(MethodDescriptor.ofConstructor((String)configObjectClassStr, (String[])new String[0]), new ResultHandle[0]) : (ResultHandle)instanceFactory.apply(methodCreator, configObjectClassStr);
        ArrayList<ConfigPropertyBuildItemCandidate> configPropertyBuildItemCandidates = new ArrayList<ConfigPropertyBuildItemCandidate>();
        ClassInfo currentClassInHierarchy = configClassInfo;
        while (true) {
            if (!Modifier.isPublic(currentClassInHierarchy.flags())) {
                throw new IllegalArgumentException("Class '" + configObjectClassStr + "' which is annotated with '" + ConfigurationPropertiesProcessor.CONFIGURATION_PROPERTIES + "' must be public, as must be the case for all of its super classes");
            }
            List fields = currentClassInHierarchy.fields();
            block1: for (FieldInfo field : fields) {
                Type fieldType;
                AnnotationValue configPropertyDefaultValue;
                if (Modifier.isStatic(field.flags())) continue;
                AnnotationInstance configPropertyAnnotation = field.annotation(DotNames.CONFIG_PROPERTY);
                if (configPropertyAnnotation != null && (configPropertyDefaultValue = configPropertyAnnotation.value("defaultValue")) != null && !configPropertyDefaultValue.asString().equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                    LOGGER.warn((Object)("'defaultValue' of '@ConfigProperty' is ignored when added to a field of a class annotated with '@ConfigProperties'. Offending field is '" + field.name() + "' of class '" + field.declaringClass().toString() + "'"));
                }
                boolean useFieldAccess = false;
                String setterName = JavaBeanUtil.getSetterName((String)field.name());
                MethodInfo setter = currentClassInHierarchy.method(setterName, new Type[]{fieldType = field.type()});
                if (setter == null) {
                    if (!Modifier.isPublic(field.flags()) || Modifier.isFinal(field.flags())) {
                        String message = "Configuration properties class '" + configClassInfo + "' does not have a setter for field '" + field.name() + "' nor is the field a public non-final field.";
                        if (failOnMismatchingMember) {
                            throw new IllegalArgumentException(message);
                        }
                        LOGGER.warn((Object)(message + " It will therefore be ignored."));
                        continue;
                    }
                    useFieldAccess = true;
                }
                if (!useFieldAccess && !Modifier.isPublic(setter.flags())) {
                    throw new IllegalArgumentException("Setter '" + setterName + "' of class '" + configClassInfo + "' must be public");
                }
                DotName fieldTypeDotName = fieldType.name();
                ClassInfo fieldTypeClassInfo = this.applicationIndex.getClassByName(fieldType.name());
                ResultHandle mpConfig = methodCreator.getMethodParam(0);
                if (fieldTypeClassInfo != null) {
                    if (DotNames.ENUM.equals((Object)fieldTypeClassInfo.superName())) {
                        ClassConfigurationPropertiesUtil.populateTypicalProperty(methodCreator, configObject, configPropertyBuildItemCandidates, currentClassInHierarchy, field, useFieldAccess, fieldType, setter, mpConfig, ClassConfigurationPropertiesUtil.getFullConfigName(prefixStr, namingStrategy, field));
                        List methods = fieldTypeClassInfo.methods();
                        for (MethodInfo method : methods) {
                            if (!method.name().equals("valueOf") || method.parametersCount() != 1 || !method.parameterType(0).name().equals((Object)DotNames.STRING)) continue;
                            this.reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(method));
                            continue block1;
                        }
                        continue;
                    }
                    if (fieldTypeClassInfo.hasNoArgsConstructor()) {
                        if (!Modifier.isPublic(fieldTypeClassInfo.flags())) {
                            throw new IllegalArgumentException("Nested configuration class '" + fieldTypeClassInfo + "' must be public ");
                        }
                        ResultHandle nestedConfigObject = this.populateConfigObject(classLoader, fieldTypeClassInfo, ClassConfigurationPropertiesUtil.getFullConfigName(prefixStr, namingStrategy, field), namingStrategy, failOnMismatchingMember, null, methodCreator);
                        ClassConfigurationPropertiesUtil.createWriteValue((BytecodeCreator)methodCreator, configObject, field, setter, useFieldAccess, nestedConfigObject);
                        continue;
                    }
                    LOGGER.warn((Object)("Nested configuration class '" + fieldTypeClassInfo + "' declared in '" + currentClassInHierarchy.name() + "." + field.name() + "' is either an interface or does not have a non-args constructor, so this field will not be initialized"));
                    continue;
                }
                String fullConfigName = ClassConfigurationPropertiesUtil.getFullConfigName(prefixStr, namingStrategy, field);
                if (DotNames.OPTIONAL.equals((Object)fieldTypeDotName)) {
                    Type genericType = ConfigurationPropertiesUtil.determineSingleGenericType(field.type(), field.declaringClass().name());
                    if (genericType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                        ConfigurationPropertiesUtil.registerImplicitConverter(genericType, this.reflectiveClasses);
                        ResultHandle setterValue = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Config.class, (String)"getOptionalValue", Optional.class, (Class[])new Class[]{String.class, Class.class}), mpConfig, new ResultHandle[]{methodCreator.load(fullConfigName), methodCreator.loadClassFromTCCL(genericType.name().toString())});
                        ClassConfigurationPropertiesUtil.createWriteValue((BytecodeCreator)methodCreator, configObject, field, setter, useFieldAccess, setterValue);
                        continue;
                    }
                    ConfigurationPropertiesUtil.ReadOptionalResponse readOptionalResponse = ConfigurationPropertiesUtil.createReadOptionalValueAndConvertIfNeeded(fullConfigName, genericType, field.declaringClass().name(), (BytecodeCreator)methodCreator, mpConfig);
                    ClassConfigurationPropertiesUtil.createWriteValue(readOptionalResponse.getIsPresentTrue(), configObject, field, setter, useFieldAccess, readOptionalResponse.getIsPresentTrue().invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{readOptionalResponse.getValue()}));
                    ClassConfigurationPropertiesUtil.createWriteValue(readOptionalResponse.getIsPresentFalse(), configObject, field, setter, useFieldAccess, readOptionalResponse.getIsPresentFalse().invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]), new ResultHandle[0]));
                    continue;
                }
                if (ConfigurationPropertiesUtil.isListOfObject(fieldType)) {
                    if (!this.capabilities.isPresent("io.quarkus.config.yaml")) {
                        throw new DeploymentException("Support for List of objects in classes annotated with '@ConfigProperties' is only possible via the 'quarkus-config-yaml' extension. Offending field is '" + field.name() + "' of class '" + field.declaringClass().name().toString());
                    }
                    ResultHandle setterValue = this.yamlListObjectHandler.handle(new YamlListObjectHandler.FieldMember(field), methodCreator, mpConfig, ClassConfigurationPropertiesUtil.getEffectiveConfigName(namingStrategy, field), fullConfigName);
                    ClassConfigurationPropertiesUtil.createWriteValue((BytecodeCreator)methodCreator, configObject, field, setter, useFieldAccess, setterValue);
                    continue;
                }
                ConfigurationPropertiesUtil.registerImplicitConverter(fieldType, this.reflectiveClasses);
                ClassConfigurationPropertiesUtil.populateTypicalProperty(methodCreator, configObject, configPropertyBuildItemCandidates, currentClassInHierarchy, field, useFieldAccess, fieldType, setter, mpConfig, fullConfigName);
            }
            ConfigPropertyBuildItemCandidateUtil.removePropertiesWithDefaultValue(classLoader, currentClassInHierarchy.name().toString(), configPropertyBuildItemCandidates);
            DotName superClassDotName = currentClassInHierarchy.superName();
            if (superClassDotName.equals((Object)DotNames.OBJECT)) break;
            ClassInfo newCurrentClassInHierarchy = this.applicationIndex.getClassByName(superClassDotName);
            if (newCurrentClassInHierarchy == null) {
                if (superClassDotName.toString().startsWith("java.")) break;
                LOGGER.warn((Object)("Class '" + superClassDotName + "' which is a parent class of '" + currentClassInHierarchy.name() + "' is not part of the Jandex index so its fields will be ignored. If you intended to include these fields, consider making the dependency part of the Jandex index by following the advice at: https://quarkus.io/guides/cdi-reference#bean_discovery"));
                break;
            }
            currentClassInHierarchy = newCurrentClassInHierarchy;
        }
        for (ConfigPropertyBuildItemCandidate candidate : configPropertyBuildItemCandidates) {
            this.configProperties.produce((BuildItem)new ConfigPropertyBuildItem(candidate.getConfigPropertyName(), candidate.getConfigPropertyType(), null));
        }
        return configObject;
    }

    private static void populateTypicalProperty(MethodCreator methodCreator, ResultHandle configObject, List<ConfigPropertyBuildItemCandidate> configPropertyBuildItemCandidates, ClassInfo currentClassInHierarchy, FieldInfo field, boolean useFieldAccess, Type fieldType, MethodInfo setter, ResultHandle mpConfig, String fullConfigName) {
        if (ClassConfigurationPropertiesUtil.shouldCheckForDefaultValue(currentClassInHierarchy, field)) {
            ConfigurationPropertiesUtil.ReadOptionalResponse readOptionalResponse = ConfigurationPropertiesUtil.createReadOptionalValueAndConvertIfNeeded(fullConfigName, fieldType, field.declaringClass().name(), (BytecodeCreator)methodCreator, mpConfig);
            ClassConfigurationPropertiesUtil.createWriteValue(readOptionalResponse.getIsPresentTrue(), configObject, field, setter, useFieldAccess, readOptionalResponse.getValue());
        } else {
            ResultHandle setterValue = ConfigurationPropertiesUtil.createReadMandatoryValueAndConvertIfNeeded(fullConfigName, fieldType, field.declaringClass().name(), (BytecodeCreator)methodCreator, mpConfig);
            ClassConfigurationPropertiesUtil.createWriteValue((BytecodeCreator)methodCreator, configObject, field, setter, useFieldAccess, setterValue);
        }
        if (field.type().kind() != Type.Kind.PRIMITIVE) {
            configPropertyBuildItemCandidates.add(new ConfigPropertyBuildItemCandidate(field.name(), fullConfigName, fieldType));
        }
    }

    private static String getFullConfigName(String prefixStr, ConfigMapping.NamingStrategy namingStrategy, FieldInfo field) {
        return prefixStr + "." + ClassConfigurationPropertiesUtil.getEffectiveConfigName(namingStrategy, field);
    }

    private static String getEffectiveConfigName(ConfigMapping.NamingStrategy namingStrategy, FieldInfo field) {
        AnnotationValue configPropertyNameValue;
        String nameToUse = field.name();
        AnnotationInstance configPropertyAnnotation = field.annotation(DotNames.CONFIG_PROPERTY);
        if (configPropertyAnnotation != null && (configPropertyNameValue = configPropertyAnnotation.value("name")) != null && !configPropertyNameValue.asString().isEmpty()) {
            nameToUse = configPropertyNameValue.asString();
        }
        return ClassConfigurationPropertiesUtil.getName(nameToUse, namingStrategy);
    }

    static String getName(final String nameToUse, ConfigMapping.NamingStrategy namingStrategy) {
        switch (namingStrategy) {
            case KEBAB_CASE: {
                return StringUtil.hyphenate((String)nameToUse);
            }
            case VERBATIM: {
                return nameToUse;
            }
            case SNAKE_CASE: {
                return String.join((CharSequence)"_", (Iterable<? extends CharSequence>)new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)nameToUse));
                    }
                });
            }
        }
        throw new IllegalArgumentException("Unsupported naming strategy: " + namingStrategy);
    }

    private static void createWriteValue(BytecodeCreator bytecodeCreator, ResultHandle configObject, FieldInfo field, MethodInfo setter, boolean useFieldAccess, ResultHandle value) {
        if (useFieldAccess) {
            ClassConfigurationPropertiesUtil.createFieldWrite(bytecodeCreator, configObject, field, value);
        } else {
            ClassConfigurationPropertiesUtil.createSetterCall(bytecodeCreator, configObject, setter, value);
        }
    }

    private static void createSetterCall(BytecodeCreator bytecodeCreator, ResultHandle configObject, MethodInfo setter, ResultHandle value) {
        bytecodeCreator.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)setter), configObject, new ResultHandle[]{value});
    }

    private static void createFieldWrite(BytecodeCreator bytecodeCreator, ResultHandle configObject, FieldInfo field, ResultHandle value) {
        bytecodeCreator.writeInstanceField(FieldDescriptor.of((FieldInfo)field), configObject, value);
    }

    private static boolean shouldCheckForDefaultValue(ClassInfo configPropertiesClassInfo, FieldInfo field) {
        String getterName = JavaBeanUtil.getGetterName((String)field.name(), (DotName)field.type().name());
        MethodInfo getterMethod = configPropertiesClassInfo.method(getterName, new Type[0]);
        if (getterMethod != null) {
            return Modifier.isPublic(getterMethod.flags());
        }
        return !Modifier.isFinal(field.flags()) && Modifier.isPublic(field.flags());
    }

    private static void createValidationCodePath(MethodCreator bytecodeCreator, ResultHandle configObject, String configPrefix) {
        ResultHandle validationResult = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)VALIDATOR_CLASS, (String)"validate", Set.class, (Object[])new Object[]{Object.class, Class[].class}), bytecodeCreator.getMethodParam(1), new ResultHandle[]{configObject, bytecodeCreator.newArray(Class.class, 0)});
        ResultHandle constraintSetIsEmpty = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Set.class, (String)"isEmpty", Boolean.TYPE, (Class[])new Class[0]), validationResult, new ResultHandle[0]);
        BranchResult constraintSetIsEmptyBranch = bytecodeCreator.ifNonZero(constraintSetIsEmpty);
        constraintSetIsEmptyBranch.trueBranch().returnValue(configObject);
        BytecodeCreator constraintSetIsEmptyFalse = constraintSetIsEmptyBranch.falseBranch();
        ResultHandle exception = constraintSetIsEmptyFalse.newInstance(MethodDescriptor.ofConstructor((String)CONSTRAINT_VIOLATION_EXCEPTION_CLASS, (String[])new String[]{Set.class.getName()}), new ResultHandle[]{validationResult});
        constraintSetIsEmptyFalse.throwException(exception);
    }
}

