/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.runtime.interceptor;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.runtime.interceptor.check.SupplierRolesAllowedCheck;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.check.AllDelegatingSecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.check.AnonymousCheck;
import io.quarkus.spring.security.runtime.interceptor.check.AnyDelegatingSecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.check.CombinedRoleSupplier;
import io.quarkus.spring.security.runtime.interceptor.check.FromBeanRoleSupplier;
import io.quarkus.spring.security.runtime.interceptor.check.PrincipalNameFromParameterObjectSecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.check.PrincipalNameFromParameterSecurityCheck;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;

@Recorder
public class SpringSecurityRecorder {
    public SecurityCheck anonymous() {
        return AnonymousCheck.INSTANCE;
    }

    public SecurityCheck allDelegating(List<SecurityCheck> securityChecks) {
        return new AllDelegatingSecurityCheck(securityChecks);
    }

    public SecurityCheck anyDelegating(List<SecurityCheck> securityChecks) {
        return new AnyDelegatingSecurityCheck(securityChecks);
    }

    public Supplier<String[]> staticHasRole(final String role) {
        return new Supplier<String[]>(){

            @Override
            public String[] get() {
                return new String[]{role};
            }
        };
    }

    public Supplier<String[]> fromBeanField(String className, String fieldName) {
        try {
            return new FromBeanRoleSupplier(Class.forName(className, false, Thread.currentThread().getContextClassLoader()), fieldName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public SecurityCheck rolesAllowed(List<Supplier<String[]>> delegates) {
        return new SupplierRolesAllowedCheck((Supplier)new CombinedRoleSupplier(delegates));
    }

    public SecurityCheck principalNameFromParameterSecurityCheck(int index, PrincipalNameFromParameterSecurityCheck.CheckType type) {
        return PrincipalNameFromParameterSecurityCheck.of(index, type);
    }

    public SecurityCheck fromGeneratedClass(String generatedClassName) {
        try {
            Class<?> type = Class.forName(generatedClassName, false, Thread.currentThread().getContextClassLoader());
            Method m = type.getDeclaredMethod("getInstance", new Class[0]);
            return (SecurityCheck)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SecurityCheck principalNameFromParameterObjectSecurityCheck(int index, String expectedParameterClass, String stringPropertyAccessorClass, String propertyName) {
        return PrincipalNameFromParameterObjectSecurityCheck.of(index, expectedParameterClass, stringPropertyAccessorClass, propertyName);
    }
}

