/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;

public class RestorableSystemProperties
implements Closeable {
    final Map<String, String> sysPropRestore;

    RestorableSystemProperties(Map<String, String> sysPropRestore) {
        this.sysPropRestore = sysPropRestore;
    }

    public static RestorableSystemProperties setProperties(Map<String, String> props, String ... additionalKeysToSave) {
        HashMap<String, String> sysPropRestore = new HashMap<String, String>();
        for (String i : additionalKeysToSave) {
            sysPropRestore.put(i, System.getProperty(i));
        }
        for (Map.Entry entry : props.entrySet()) {
            sysPropRestore.put((String)entry.getKey(), System.getProperty((String)entry.getKey()));
        }
        for (Map.Entry entry : props.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException(String.format("Internal error: Cannot set null key as a system property (value is %s)", entry.getValue()));
            }
            if (entry.getValue() == null) {
                throw new IllegalArgumentException(String.format("Internal error: Cannot use null value as a system property (key is %s)", entry.getKey()));
            }
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return new RestorableSystemProperties(sysPropRestore);
    }

    @Override
    public void close() {
        for (Map.Entry<String, String> entry : this.sysPropRestore.entrySet()) {
            String val = entry.getValue();
            if (val == null) {
                System.clearProperty(entry.getKey());
                continue;
            }
            System.setProperty(entry.getKey(), val);
        }
    }
}

