/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common.http;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ExpressionConfigSourceInterceptor;
import jakarta.annotation.Priority;

@Priority(value=3299)
public class TestHTTPConfigSourceInterceptor
extends ExpressionConfigSourceInterceptor {
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (name.equals("test.url") || name.equals("test.management.url") || name.equals("test.url.ssl") || name.equals("test.management.url.ssl")) {
            return TestHTTPConfigSourceInterceptor.sanitizeUrl(super.getValue(context, name));
        }
        if (name.equals("quarkus.http.root-path") || name.equals("quarkus.http.management-path")) {
            ConfigValue configValue = super.getValue(context, name);
            if (configValue == null || configValue.getRawValue() == null || configValue.getRawValue().isEmpty() || configValue.getRawValue().startsWith("/")) {
                return configValue;
            }
            return configValue.from().withValue("/" + configValue.getValue()).withRawValue("/" + configValue.getRawValue()).build();
        }
        return context.proceed(name);
    }

    private static ConfigValue sanitizeUrl(ConfigValue configValue) {
        if (configValue == null || configValue.getValue() == null) {
            return configValue;
        }
        String url = configValue.getValue();
        if ((url = url.replace("0.0.0.0", "localhost")).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return configValue.from().withValue(url).build();
    }
}

