/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it.assertions;

import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.testing.RegistryClientTestHelper;
import io.quarkus.maven.it.assertions.JarVerifier;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class SetupVerifier {
    public static void assertThatJarExists(File archive) throws Exception {
        JarVerifier jarVerifier = new JarVerifier(archive);
        jarVerifier.assertThatJarIsCreated();
        jarVerifier.assertThatJarHasManifest();
    }

    public static void assertThatJarContainsFile(File archive, String file) throws Exception {
        JarVerifier jarVerifier = new JarVerifier(archive);
        jarVerifier.assertThatFileIsContained(file);
    }

    public static void assertThatJarDoesNotContainFile(File archive, String file) throws Exception {
        JarVerifier jarVerifier = new JarVerifier(archive);
        jarVerifier.assertThatFileIsNotContained(file);
    }

    public static void assertThatJarContainsFileWithContent(File archive, String path, String ... lines) throws Exception {
        JarVerifier jarVerifier = new JarVerifier(archive);
        jarVerifier.assertThatFileContains(path, lines);
    }

    public static void verifySetup(File pomFile) throws Exception {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)pomFile, (String)"Unable to find pom.xml");
        MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
        Model model = xpp3Reader.read((InputStream)new FileInputStream(pomFile));
        MavenProject project = new MavenProject(model);
        Optional<Plugin> maybe = SetupVerifier.hasPlugin(project, "io.quarkus:quarkus-maven-plugin");
        Assertions.assertThat(maybe).isNotEmpty();
        Properties properties = model.getProperties();
        Assertions.assertThat((boolean)properties.containsKey("quarkus.platform.group-id")).isTrue();
        Assertions.assertThat((boolean)properties.containsKey("quarkus.platform.artifact-id")).isTrue();
        Assertions.assertThat((boolean)properties.containsKey("quarkus.platform.version")).isTrue();
        Assertions.assertThat((boolean)properties.containsKey("quarkus-plugin.version")).isTrue();
        Plugin plugin = maybe.orElseThrow(() -> new AssertionError((Object)"Plugin expected"));
        ((ObjectAssert)Assertions.assertThat((Object)plugin).isNotNull()).satisfies(new ThrowingConsumer[]{p -> {
            Assertions.assertThat((String)p.getArtifactId()).isEqualTo("quarkus-maven-plugin");
            Assertions.assertThat((String)p.getGroupId()).isEqualTo("io.quarkus");
            Assertions.assertThat((String)p.getVersion()).isEqualTo(MojoUtils.TEMPLATE_PROPERTY_QUARKUS_PLUGIN_VERSION_VALUE);
        }});
        ((ListAssert)Assertions.assertThat((List)plugin.getExecutions()).hasSize(1)).allSatisfy(execution -> {
            Assertions.assertThat((List)execution.getGoals()).containsExactly((Object[])new String[]{"build"});
            Assertions.assertThat((Object)execution.getConfiguration()).isNull();
        });
        Assertions.assertThat((List)model.getProfiles()).hasSize(1);
        Profile profile = (Profile)model.getProfiles().get(0);
        Assertions.assertThat((String)profile.getId()).isEqualTo("native");
        Plugin actual = (Plugin)profile.getBuild().getPluginsAsMap().get("io.quarkus:quarkus-maven-plugin");
        Assertions.assertThat((Object)actual).isNotNull();
        ((ListAssert)Assertions.assertThat((List)actual.getExecutions()).hasSize(1)).allSatisfy(exec -> {
            Assertions.assertThat((List)exec.getGoals()).containsExactly((Object[])new String[]{"native-image"});
            ((ObjectAssert)Assertions.assertThat((Object)exec.getConfiguration()).isInstanceOf(Xpp3Dom.class)).satisfies(new ThrowingConsumer[]{o -> Assertions.assertThat((String)o.toString()).contains(new CharSequence[]{"enableHttpUrlHandler"})});
        });
    }

    public static Optional<Plugin> hasPlugin(MavenProject project, String pluginKey) {
        Optional<Plugin> optPlugin = project.getBuildPlugins().stream().filter(plugin -> pluginKey.equals(plugin.getKey())).findFirst();
        if (!optPlugin.isPresent() && project.getPluginManagement() != null) {
            optPlugin = project.getPluginManagement().getPlugins().stream().filter(plugin -> pluginKey.equals(plugin.getKey())).findFirst();
        }
        return optPlugin;
    }

    public static void verifySetupWithVersion(File pomFile) throws Exception {
        MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
        Model model = xpp3Reader.read((InputStream)new FileInputStream(pomFile));
        MavenProject project = new MavenProject(model);
        Properties projectProps = project.getProperties();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)projectProps);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)projectProps.isEmpty());
        String quarkusVersion = SetupVerifier.getPlatformDescriptor().getQuarkusCoreVersion();
        org.junit.jupiter.api.Assertions.assertEquals((Object)quarkusVersion, (Object)projectProps.getProperty("quarkus-plugin.version"));
    }

    private static ExtensionCatalog getPlatformDescriptor() throws Exception {
        RegistryClientTestHelper.enableRegistryClientTestConfig();
        try {
            ExtensionCatalog extensionCatalog = QuarkusProjectHelper.getCatalogResolver().resolveExtensionCatalog();
            return extensionCatalog;
        }
        finally {
            RegistryClientTestHelper.disableRegistryClientTestConfig();
        }
    }
}

