/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it.continuoustesting;

import io.quarkus.maven.it.continuoustesting.ContinuousTestingMavenTestUtils;
import io.quarkus.maven.it.verifier.RunningInvoker;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;

public class TestModeContinuousTestingMavenTestUtils
extends ContinuousTestingMavenTestUtils {
    private static final Pattern ALL_PASSING = Pattern.compile("(?:\\e\\[[\\d;]+m)*All (\\d+) tests? (?:are|is) passing \\((\\d+) skipped\\)", 8);
    private static final Pattern SOME_PASSING = Pattern.compile("(?:\\e\\[[\\d;]+m)*(\\d+) tests? failed(?:\\e\\[[\\d;]+m)* \\((?:\\e\\[[\\d;]+m)*(\\d+) passing(?:\\e\\[[\\d;]+m)*, (?:\\e\\[[\\d;]+m)*(\\d+) skipped(?:\\e\\[[\\d;]+m)*\\)", 8);
    private static final String TESTS_COMPLETED = "Tests completed at";
    private final RunningInvoker running;
    private int startPosition = 0;

    public TestModeContinuousTestingMavenTestUtils(RunningInvoker running) {
        this.running = running;
    }

    @Override
    public ContinuousTestingMavenTestUtils.TestStatus waitForNextCompletion() {
        Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(3L, TimeUnit.MINUTES).until(() -> this.getLogSinceLastRun().contains(TESTS_COMPLETED));
        ContinuousTestingMavenTestUtils.TestStatus testStatus = new ContinuousTestingMavenTestUtils.TestStatus();
        try {
            int failCount;
            int skipCount;
            int passCount;
            String log = this.getLogSinceLastRun();
            Matcher matcher = ALL_PASSING.matcher(log);
            if (matcher.find()) {
                passCount = Integer.parseInt(matcher.group(1));
                skipCount = Integer.parseInt(matcher.group(2));
                failCount = 0;
            } else {
                matcher = SOME_PASSING.matcher(log);
                if (!matcher.find()) {
                    Path f = File.createTempFile("quarkus-maven-test-debug-log", ".txt").toPath();
                    Files.writeString(f, (CharSequence)log, StandardCharsets.UTF_8, new OpenOption[0]);
                    Assertions.fail((String)("Tests were run, but the log is not parseable with the patterns we know, " + System.lineSeparator() + "i.e. neither \"" + ALL_PASSING.pattern() + "\" nor \"" + SOME_PASSING.pattern() + "\"." + System.lineSeparator() + " Note that possible terminal control characters might not be seen here. " + System.lineSeparator() + "Check the text file dump too: " + String.valueOf(f.toAbsolutePath()) + ". This is the log:" + System.lineSeparator() + log));
                }
                failCount = Integer.parseInt(matcher.group(1));
                passCount = Integer.parseInt(matcher.group(2));
                skipCount = Integer.parseInt(matcher.group(3));
            }
            testStatus.setTestsFailed(failCount);
            testStatus.setTestsPassed(passCount);
            testStatus.setTestsSkipped(skipCount);
            testStatus.setTotalTestsFailed(failCount);
            testStatus.setTotalTestsPassed(passCount);
            testStatus.setTotalTestsSkipped(skipCount);
            this.setHighWaterMark();
        }
        catch (IOException e) {
            Assertions.fail((Throwable)e);
        }
        return testStatus;
    }

    private void setHighWaterMark() throws IOException {
        this.startPosition = this.startPosition + this.getLogSinceLastRun().indexOf(TESTS_COMPLETED) + TESTS_COMPLETED.length();
    }

    private String getLogSinceLastRun() throws IOException {
        String log = this.running.log();
        return log.substring(this.startPosition);
    }
}

