/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it;

import io.quarkus.maven.it.MojoTestBase;
import io.quarkus.maven.it.verifier.MavenProcessInvocationResult;
import io.quarkus.maven.it.verifier.RunningInvoker;
import io.quarkus.test.devmode.util.DevModeClient;
import io.quarkus.utilities.JavaBinFinder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;

public class RunAndCheckWithAgentMojoTestBase
extends MojoTestBase {
    protected RunningInvoker runningAgent;
    private Process runningRemote;
    protected File agentDir;
    protected File testDir;
    protected DevModeClient devModeClient = new DevModeClient();

    @AfterEach
    public void cleanup() throws IOException {
        try {
            if (this.runningRemote != null) {
                this.runningRemote.destroyForcibly().waitFor();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (this.runningAgent != null) {
                this.runningAgent.stop();
            }
            this.devModeClient.awaitUntilServerDown();
        }
    }

    protected void runAndCheck(String ... options) throws FileNotFoundException, MavenInvocationException {
        try {
            RunningInvoker running = new RunningInvoker(this.testDir, false);
            MavenProcessInvocationResult result = running.execute(Arrays.asList("package", "-DskipTests", "-Dquarkus.analytics.disabled=true"), Collections.emptyMap());
            Awaitility.await().atMost(1L, TimeUnit.MINUTES).until(() -> result.getProcess() != null && !result.getProcess().isAlive());
            Assertions.assertThat((String)running.log()).containsIgnoringCase((CharSequence)"BUILD SUCCESS");
            running.stop();
            Path jar = this.testDir.toPath().toAbsolutePath().resolve(Paths.get("target/quarkus-app/quarkus-run.jar", new String[0]));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(jar, new LinkOption[0]));
            File output = new File(this.testDir, "target/output.log");
            output.createNewFile();
            this.runningRemote = this.doLaunch(jar, output);
            Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(1L, TimeUnit.MINUTES).until(() -> this.devModeClient.getHttpResponse("/", 200));
            this.runningAgent = new RunningInvoker(this.agentDir, false);
            this.runningAgent.execute(Arrays.asList("compile", "quarkus:remote-dev"), Collections.emptyMap());
            Thread.sleep(1000L);
            Awaitility.await().pollDelay(100L, TimeUnit.MILLISECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).atMost(1L, TimeUnit.MINUTES).until(() -> this.runningAgent.log().contains("Connected to remote server"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Process doLaunch(Path jar, File output) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(JavaBinFinder.findBin());
        commands.add("-jar");
        commands.add(jar.toString());
        ProcessBuilder processBuilder = new ProcessBuilder(commands.toArray(new String[0]));
        processBuilder.redirectOutput(output);
        processBuilder.redirectError(output);
        processBuilder.environment().put("QUARKUS_LAUNCH_DEVMODE", "true");
        return processBuilder.start();
    }
}

