/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it.continuoustesting;

import com.fasterxml.jackson.core.type.TypeReference;
import io.quarkus.devui.tests.DevUIJsonRPCTest;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public class ContinuousTestingMavenTestUtils {
    private static final int DEFAULT_PORT = 8080;
    long runtToWaitFor = 1L;
    final String host;

    protected static String getDefaultHost(int port) {
        return "http://localhost:" + port;
    }

    public ContinuousTestingMavenTestUtils() {
        this(ContinuousTestingMavenTestUtils.getDefaultHost(8080));
    }

    public ContinuousTestingMavenTestUtils(int port) {
        this(ContinuousTestingMavenTestUtils.getDefaultHost(port));
    }

    public ContinuousTestingMavenTestUtils(String host) {
        this.host = host;
    }

    public TestStatus waitForNextCompletion() {
        try {
            Awaitility.waitAtMost((long)2L, (TimeUnit)TimeUnit.MINUTES).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> {
                boolean runComplete;
                TestStatus ts = this.getTestStatus();
                if (ts.getLastRun() > this.runtToWaitFor) {
                    throw new RuntimeException("Waiting for run " + this.runtToWaitFor + " but run " + ts.getLastRun() + " has already occurred");
                }
                boolean bl = runComplete = ts.getLastRun() == this.runtToWaitFor;
                if (runComplete && ts.getRunning() > 0L) {
                    this.runtToWaitFor = ts.getRunning();
                    return false;
                }
                if (runComplete) {
                    ++this.runtToWaitFor;
                }
                return runComplete;
            });
            return this.getTestStatus();
        }
        catch (Exception e) {
            TestStatus ts;
            try {
                ts = this.getTestStatus();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            throw new ConditionTimeoutException("Failed to wait for test run " + this.runtToWaitFor + " " + String.valueOf(ts), (Throwable)e);
        }
    }

    public static String appProperties(String ... props) {
        return "quarkus.test.continuous-testing=enabled\nquarkus.test.display-test-output=true\nquarkus.console.basic=true\nquarkus.console.disable-input=true\n" + String.join((CharSequence)"\n", Arrays.asList(props));
    }

    private TestStatus getTestStatus() {
        DevUIJsonRPCTest devUIJsonRPCTest = new DevUIJsonRPCTest("devui-continuous-testing", this.host);
        try {
            TypeReference<Map<String, Long>> typeRef = new TypeReference<Map<String, Long>>(){};
            Map testStatus = (Map)devUIJsonRPCTest.executeJsonRPCMethod((TypeReference)typeRef, "getStatus");
            long lastRun = testStatus.getOrDefault("lastRun", -1L);
            long running = testStatus.getOrDefault("running", -1L);
            long testsRun = testStatus.getOrDefault("testsRun", -1L);
            long testsPassed = testStatus.getOrDefault("testsPassed", -1L);
            long testsFailed = testStatus.getOrDefault("testsFailed", -1L);
            long testsSkipped = testStatus.getOrDefault("testsSkipped", -1L);
            long totalTestsPassed = testStatus.getOrDefault("totalTestsPassed", -1L);
            long totalTestsFailed = testStatus.getOrDefault("totalTestsFailed", -1L);
            long totalTestsSkipped = testStatus.getOrDefault("totalTestsSkipped", -1L);
            return new TestStatus(lastRun, running, testsRun, testsPassed, testsFailed, testsSkipped, totalTestsPassed, totalTestsFailed, totalTestsSkipped);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class TestStatus {
        private long lastRun;
        private long running;
        private long testsRun = -1L;
        private long testsPassed = -1L;
        private long testsFailed = -1L;
        private long testsSkipped = -1L;
        private long totalTestsPassed = -1L;
        private long totalTestsFailed = -1L;
        private long totalTestsSkipped = -1L;

        public TestStatus() {
        }

        public TestStatus(long lastRun, long running, long testsRun, long testsPassed, long testsFailed, long testsSkipped, long totalTestsPassed, long totalTestsFailed, long totalTestsSkipped) {
            this.lastRun = lastRun;
            this.running = running;
            this.testsRun = testsRun;
            this.testsPassed = testsPassed;
            this.testsFailed = testsFailed;
            this.testsSkipped = testsSkipped;
            this.totalTestsPassed = totalTestsPassed;
            this.totalTestsFailed = totalTestsFailed;
            this.totalTestsSkipped = totalTestsSkipped;
        }

        public long getLastRun() {
            return this.lastRun;
        }

        public void setLastRun(long lastRun) {
            this.lastRun = lastRun;
        }

        public long getRunning() {
            return this.running;
        }

        public void setRunning(long running) {
            this.running = running;
        }

        public long getTestsRun() {
            return this.testsRun;
        }

        public void setTestsRun(long testsRun) {
            this.testsRun = testsRun;
        }

        public long getTestsPassed() {
            return this.testsPassed;
        }

        public void setTestsPassed(long testsPassed) {
            this.testsPassed = testsPassed;
        }

        public long getTestsFailed() {
            return this.testsFailed;
        }

        public void setTestsFailed(long testsFailed) {
            this.testsFailed = testsFailed;
        }

        public long getTestsSkipped() {
            return this.testsSkipped;
        }

        public void setTestsSkipped(long testsSkipped) {
            this.testsSkipped = testsSkipped;
        }

        public long getTotalTestsPassed() {
            return this.totalTestsPassed;
        }

        public void setTotalTestsPassed(long totalTestsPassed) {
            this.totalTestsPassed = totalTestsPassed;
        }

        public long getTotalTestsFailed() {
            return this.totalTestsFailed;
        }

        public void setTotalTestsFailed(long totalTestsFailed) {
            this.totalTestsFailed = totalTestsFailed;
        }

        public long getTotalTestsSkipped() {
            return this.totalTestsSkipped;
        }

        public void setTotalTestsSkipped(long totalTestsSkipped) {
            this.totalTestsSkipped = totalTestsSkipped;
        }

        public String toString() {
            return "TestStatus{lastRun=" + this.lastRun + ", running=" + this.running + ", testsRun=" + this.testsRun + ", testsPassed=" + this.testsPassed + ", testsFailed=" + this.testsFailed + ", testsSkipped=" + this.testsSkipped + ", totalTestsPassed=" + this.totalTestsPassed + ", totalTestsFailed=" + this.totalTestsFailed + ", totalTestsSkipped=" + this.totalTestsSkipped + "}";
        }
    }
}

