/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AttributeType {
    LONG{

        @Override
        Object convert(String value) {
            return Long.valueOf(value);
        }
    }
    ,
    INTEGER{

        @Override
        Object convert(String value) {
            return Integer.valueOf(value);
        }
    }
    ,
    BOOLEAN{

        @Override
        Object convert(String value) {
            return Boolean.valueOf(value);
        }
    }
    ,
    STRING{

        @Override
        Object convert(String value) {
            return value;
        }
    }
    ,
    STRING_SET{

        @Override
        Object convert(String value) {
            return Set.of(value.split(","));
        }
    }
    ,
    JSON_ARRAY{

        @Override
        Object convert(String value) {
            try (JsonReader reader = Json.createReader((Reader)new StringReader(value));){
                JsonArray jsonArray = reader.readArray();
                return jsonArray;
            }
        }
    }
    ,
    JSON_OBJECT{

        @Override
        Object convert(String value) {
            try (JsonReader reader = Json.createReader((Reader)new StringReader(value));){
                JsonObject jsonObject = reader.readObject();
                return jsonObject;
            }
        }
    }
    ,
    DEFAULT{

        @Override
        Object convert(String value) {
            return value;
        }
    };


    abstract Object convert(String var1);
}

