/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.test.security.TestIdentityAssociation;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

abstract class AbstractTestHttpAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    TestIdentityAssociation testIdentityAssociation;
    @Inject
    BlockingSecurityExecutor blockingSecurityExecutor;
    protected volatile String authMechanism = null;
    protected volatile List<Instance<? extends SecurityIdentityAugmentor>> augmentors = null;

    AbstractTestHttpAuthenticationMechanism() {
    }

    @PostConstruct
    public void check() {
        if (LaunchMode.current() != LaunchMode.TEST) {
            throw new RuntimeException("TestAuthController can only be used in tests");
        }
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext event, IdentityProviderManager identityProviderManager) {
        Uni identity = Uni.createFrom().item((Object)this.testIdentityAssociation.getTestIdentity());
        if (this.augmentors != null && this.testIdentityAssociation.getTestIdentity() != null) {
            AuthenticationRequestContext requestContext = new AuthenticationRequestContext(){

                public Uni<SecurityIdentity> runBlocking(Supplier<SecurityIdentity> supplier) {
                    return AbstractTestHttpAuthenticationMechanism.this.blockingSecurityExecutor.executeBlocking(supplier);
                }
            };
            Map<String, RoutingContext> requestAttributes = Map.of("quarkus.http.routing.context", event);
            for (Instance<? extends SecurityIdentityAugmentor> augmentor : this.augmentors) {
                identity = identity.flatMap(arg_0 -> AbstractTestHttpAuthenticationMechanism.lambda$authenticate$0(augmentor, requestContext, requestAttributes, arg_0));
            }
        }
        return identity;
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return Uni.createFrom().nullItem();
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.emptySet();
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        return this.authMechanism == null ? Uni.createFrom().nullItem() : Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.TEST_SECURITY, this.authMechanism));
    }

    void setAuthMechanism(String authMechanism) {
        this.authMechanism = authMechanism;
    }

    void setSecurityIdentityAugmentors(List<Instance<? extends SecurityIdentityAugmentor>> augmentors) {
        this.augmentors = augmentors;
    }

    private static /* synthetic */ Uni lambda$authenticate$0(Instance augmentor, 1 requestContext, Map requestAttributes, SecurityIdentity i) {
        return ((SecurityIdentityAugmentor)augmentor.get()).augment(i, (AuthenticationRequestContext)requestContext, requestAttributes);
    }
}

