/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.vertx;

import io.quarkus.arc.Arc;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.lang.reflect.Method;

public class VirtualThreadsAssertions {
    public static void assertEverything() {
        VirtualThreadsAssertions.assertThatTheRequestScopeIsActive();
        VirtualThreadsAssertions.assertThatItRunsOnVirtualThread();
        VirtualThreadsAssertions.assertThatItRunsOnADuplicatedContext();
    }

    public static void assertWorkerOrEventLoopThread() {
        VirtualThreadsAssertions.assertThatTheRequestScopeIsActive();
        VirtualThreadsAssertions.assertThatItRunsOnADuplicatedContext();
        VirtualThreadsAssertions.assertNotOnVirtualThread();
    }

    public static void assertThatTheRequestScopeIsActive() {
        if (!Arc.container().requestContext().isActive()) {
            throw new AssertionError((Object)"Expected the request scope to be active");
        }
    }

    public static void assertThatItRunsOnADuplicatedContext() {
        Context context = Vertx.currentContext();
        if (context == null) {
            throw new AssertionError((Object)"The method does not run on a Vert.x context");
        }
        if (!VertxContext.isOnDuplicatedContext()) {
            throw new AssertionError((Object)"The method does not run on a Vert.x **duplicated** context");
        }
    }

    public static void assertThatItRunsOnVirtualThread() {
        try {
            Method isVirtual = Thread.class.getMethod("isVirtual", new Class[0]);
            isVirtual.setAccessible(true);
            boolean virtual = (Boolean)isVirtual.invoke((Object)Thread.currentThread(), new Object[0]);
            if (!virtual) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread() + " is not a virtual thread"));
            }
        }
        catch (Exception e) {
            throw new AssertionError("Thread " + Thread.currentThread() + " is not a virtual thread - cannot invoke Thread.isVirtual()", e);
        }
    }

    public static void assertNotOnVirtualThread() {
        block3: {
            try {
                Method isVirtual = Thread.class.getMethod("isVirtual", new Class[0]);
                isVirtual.setAccessible(true);
                boolean virtual = (Boolean)isVirtual.invoke((Object)Thread.currentThread(), new Object[0]);
                if (virtual) {
                    throw new AssertionError((Object)("Thread " + Thread.currentThread() + " is a virtual thread"));
                }
            }
            catch (Exception e) {
                String name = Thread.currentThread().toString();
                if (!name.toLowerCase().contains("virtual")) break block3;
                throw new AssertionError((Object)("Thread " + Thread.currentThread() + " seems to be a virtual thread"));
            }
        }
    }
}

