/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.runtime.JavaNetSslTlsBucketConfig;
import io.quarkus.tls.runtime.KeyStoreAndKeyCertOptions;
import io.quarkus.tls.runtime.KeyStoreProvider;
import io.quarkus.tls.runtime.TlsCertificateUpdater;
import io.quarkus.tls.runtime.TrustStoreAndTrustOptions;
import io.quarkus.tls.runtime.TrustStoreProvider;
import io.quarkus.tls.runtime.VertxCertificateHolder;
import io.quarkus.tls.runtime.config.KeyStoreConfig;
import io.quarkus.tls.runtime.config.TlsBucketConfig;
import io.quarkus.tls.runtime.config.TlsConfig;
import io.quarkus.tls.runtime.config.TrustStoreConfig;
import io.quarkus.tls.runtime.keystores.JKSKeyStores;
import io.quarkus.tls.runtime.keystores.P12KeyStores;
import io.quarkus.tls.runtime.keystores.PemKeyStores;
import io.quarkus.tls.runtime.keystores.TrustAllOptions;
import io.smallrye.common.annotation.Identifier;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.security.KeyStoreException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Recorder
public class CertificateRecorder
implements TlsConfigurationRegistry {
    private final Map<String, TlsConfiguration> certificates = new ConcurrentHashMap<String, TlsConfiguration>();
    private volatile TlsCertificateUpdater reloader;
    private volatile Vertx vertx;

    public void validateCertificates(Set<String> providerBucketNames, TlsConfig config, RuntimeValue<Vertx> vertx, ShutdownContext shutdownContext) {
        this.vertx = (Vertx)vertx.getValue();
        if (config.defaultCertificateConfig().isPresent()) {
            this.verifyCertificateConfig(config.defaultCertificateConfig().get(), (Vertx)vertx.getValue(), "<default>");
        }
        HashSet<String> bucketNames = new HashSet<String>(config.namedCertificateConfig().keySet());
        bucketNames.addAll(providerBucketNames);
        for (String name : bucketNames) {
            if (name.equals("<default>")) {
                throw new IllegalArgumentException("The TLS configuration name <default> cannot be used explicitly in configuration or qualifiers");
            }
            if (name.equals("javax.net.ssl")) {
                throw new IllegalArgumentException("The TLS configuration name javax.net.ssl is reserved for providing access to default SunJSSE keystore; neither Quarkus extensions nor end users can adjust or override it");
            }
            this.verifyCertificateConfig(config.namedCertificateConfig().get(name), (Vertx)vertx.getValue(), name);
        }
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                if (CertificateRecorder.this.reloader != null) {
                    CertificateRecorder.this.reloader.close();
                }
            }
        });
    }

    public void verifyCertificateConfig(TlsBucketConfig config, Vertx vertx, String name) {
        TlsConfiguration tlsConfig = CertificateRecorder.verifyCertificateConfigInternal(config, vertx, name);
        this.certificates.put(name, tlsConfig);
        if (config.reloadPeriod().isPresent()) {
            if (this.reloader == null) {
                this.reloader = new TlsCertificateUpdater(vertx);
            }
            this.reloader.add(name, this.certificates.get(name), config.reloadPeriod().get());
        }
    }

    private static TlsConfiguration verifyCertificateConfigInternal(TlsBucketConfig config, Vertx vertx, String name) {
        KeyStoreAndKeyCertOptions ks = CertificateRecorder.getKeyStore(config, vertx, name);
        if (ks != null && config.keyStore().isPresent() && config.keyStore().get().sni()) {
            try {
                if (Collections.list(ks.keyStore.aliases()).size() <= 1) {
                    throw new IllegalStateException("The SNI option cannot be used when the keystore contains only one alias or the `alias` property has been set");
                }
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        }
        TrustStoreAndTrustOptions ts = CertificateRecorder.getTrustStore(config, vertx, name);
        if (config.trustAll() && ts != null) {
            throw new IllegalStateException("The trust-all option cannot be used when a trust-store is configured");
        }
        if (config.trustAll()) {
            ts = new TrustStoreAndTrustOptions(null, TrustAllOptions.INSTANCE);
        }
        return new VertxCertificateHolder(vertx, name, config, ks, ts);
    }

    public static KeyStoreAndKeyCertOptions getKeyStore(TlsBucketConfig bucketConfig, Vertx vertx, String name) {
        try (InstanceHandle<KeyStoreProvider> providerInstance = CertificateRecorder.lookupProvider(KeyStoreProvider.class, name);){
            if (bucketConfig.keyStore().isPresent()) {
                KeyStoreConfig config = bucketConfig.keyStore().get();
                config.validate(providerInstance, name);
                if (config.pem().isPresent()) {
                    KeyStoreAndKeyCertOptions keyStoreAndKeyCertOptions = PemKeyStores.verifyPEMKeyStore(config, vertx, name);
                    return keyStoreAndKeyCertOptions;
                }
                if (config.p12().isPresent()) {
                    KeyStoreAndKeyCertOptions keyStoreAndKeyCertOptions = P12KeyStores.verifyP12KeyStore(config, vertx, name);
                    return keyStoreAndKeyCertOptions;
                }
                if (config.jks().isPresent()) {
                    KeyStoreAndKeyCertOptions keyStoreAndKeyCertOptions = JKSKeyStores.verifyJKSKeyStore(config, vertx, name);
                    return keyStoreAndKeyCertOptions;
                }
            }
            if (providerInstance.isAvailable()) {
                KeyStoreAndKeyCertOptions keyStoreAndKeyCertOptions = ((KeyStoreProvider)providerInstance.get()).getKeyStore(vertx);
                return keyStoreAndKeyCertOptions;
            }
        }
        return null;
    }

    public static TrustStoreAndTrustOptions getTrustStore(TlsBucketConfig bucketConfig, Vertx vertx, String name) {
        try (InstanceHandle<TrustStoreProvider> providerInstance = CertificateRecorder.lookupProvider(TrustStoreProvider.class, name);){
            if (bucketConfig.trustStore().isPresent()) {
                TrustStoreConfig config = bucketConfig.trustStore().get();
                config.validate(providerInstance, name);
                if (config.pem().isPresent()) {
                    TrustStoreAndTrustOptions trustStoreAndTrustOptions = PemKeyStores.verifyPEMTrustStoreStore(config, vertx, name);
                    return trustStoreAndTrustOptions;
                }
                if (config.p12().isPresent()) {
                    TrustStoreAndTrustOptions trustStoreAndTrustOptions = P12KeyStores.verifyP12TrustStoreStore(config, vertx, name);
                    return trustStoreAndTrustOptions;
                }
                if (config.jks().isPresent()) {
                    TrustStoreAndTrustOptions trustStoreAndTrustOptions = JKSKeyStores.verifyJKSTrustStoreStore(config, vertx, name);
                    return trustStoreAndTrustOptions;
                }
            }
            if (providerInstance.isAvailable()) {
                TrustStoreAndTrustOptions trustStoreAndTrustOptions = ((TrustStoreProvider)providerInstance.get()).getTrustStore(vertx);
                return trustStoreAndTrustOptions;
            }
        }
        return null;
    }

    @Override
    public Optional<TlsConfiguration> get(String name) {
        if ("javax.net.ssl".equals(name)) {
            TlsConfiguration result = this.certificates.computeIfAbsent("javax.net.ssl", k -> CertificateRecorder.verifyCertificateConfigInternal(new JavaNetSslTlsBucketConfig(), this.vertx, "javax.net.ssl"));
            return Optional.ofNullable(result);
        }
        return Optional.ofNullable(this.certificates.get(name));
    }

    @Override
    public Optional<TlsConfiguration> getDefault() {
        return this.get("<default>");
    }

    @Override
    public void register(String name, TlsConfiguration configuration) {
        if (name == null) {
            throw new IllegalArgumentException("The name of the TLS configuration to register cannot be null");
        }
        if (name.equals("<default>")) {
            throw new IllegalArgumentException("The name of the TLS configuration to register cannot be <default>");
        }
        if (name.equals("javax.net.ssl")) {
            throw new IllegalArgumentException("The TLS configuration name javax.net.ssl is reserved for providing access to default SunJSSE keystore; neither Quarkus extensions nor end users can adjust of override it");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("The TLS configuration to register cannot be null");
        }
        this.certificates.put(name, configuration);
    }

    public Supplier<TlsConfigurationRegistry> getSupplier() {
        return new Supplier<TlsConfigurationRegistry>(){

            @Override
            public TlsConfigurationRegistry get() {
                return CertificateRecorder.this;
            }
        };
    }

    public void register(String name, Supplier<TlsConfiguration> supplier) {
        this.register(name, supplier.get());
    }

    static <T> InstanceHandle<T> lookupProvider(Class<T> type, String bucketName) {
        Default.Literal qualifier;
        ArcContainer container = Arc.container();
        List instances = container.listAll(type, new Annotation[]{qualifier = "<default>".equals(bucketName) ? Default.Literal.INSTANCE : Identifier.Literal.of((String)bucketName)});
        if (instances.size() > 1) {
            throw new AmbiguousResolutionException("multiple beans with type " + type.getName() + " found for TLS configuration " + bucketName);
        }
        if (instances.isEmpty()) {
            return new InstanceHandle<T>(){

                public T get() {
                    return null;
                }
            };
        }
        return (InstanceHandle)instances.get(0);
    }
}

